/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.command.trigger.view;

import de.mossgrabers.framework.command.trigger.view.ViewMultiSelectCommand;
import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ICursorTrack;
import de.mossgrabers.framework.featuregroup.ViewManager;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.Views;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class SelectPlayViewCommand<S extends IControlSurface<C>, C extends Configuration>
extends ViewMultiSelectCommand<S, C> {
    private final Set<Views> allViewIds = new HashSet<Views>();

    public SelectPlayViewCommand(IModel model, S surface, Views[] viewIds, Collection<Views> allViewIds) {
        super(model, surface, viewIds);
        this.allViewIds.addAll(allViewIds);
    }

    @Override
    public void executeNormal(ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        ViewManager viewManager = this.surface.getViewManager();
        if (!this.allViewIds.contains(viewManager.getActiveID())) {
            this.surface.recallPreferredView(this.model.getCursorTrack());
            return;
        }
        super.executeNormal(event);
        ICursorTrack cursorTrack = this.model.getCursorTrack();
        if (cursorTrack.doesExist()) {
            viewManager.setPreferredView(cursorTrack.getPosition(), (Views)((Object)viewManager.getActiveID()));
        }
    }
}

