/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.command.trigger.transport;

import de.mossgrabers.framework.command.trigger.AbstractDoubleTriggerCommand;
import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.ITransport;
import de.mossgrabers.framework.utils.ButtonEvent;

public class StopCommand<S extends IControlSurface<C>, C extends Configuration>
extends AbstractDoubleTriggerCommand<S, C> {
    protected final ITransport transport;

    public StopCommand(IModel model, S surface) {
        super(model, surface);
        this.transport = this.model.getTransport();
    }

    @Override
    protected void executeSingleClick() {
        if (this.transport.isPlaying()) {
            this.handleStopOptions();
        } else {
            this.transport.stopAndRewind();
            this.doubleClickTest();
        }
    }

    @Override
    protected void executeDoubleClick() {
        this.transport.setPositionToEnd();
    }

    @Override
    public void executeShifted(ButtonEvent event) {
        if (event == ButtonEvent.UP) {
            this.model.getTrackBank().stop(false);
        }
    }

    protected void handleStopOptions() {
        switch (this.surface.getConfiguration().getBehaviourOnStop()) {
            case RETURN_TO_ZERO: {
                this.transport.stopAndRewind();
                break;
            }
            case STOP: {
                this.transport.stop();
                break;
            }
            case PAUSE: {
                if (!this.transport.isPlaying()) break;
                this.transport.play();
            }
        }
    }
}

