/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.command.trigger.transport;

import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.ITransport;
import de.mossgrabers.framework.utils.ButtonEvent;

public class RecQuantizationCommand<S extends IControlSurface<C>, C extends Configuration>
extends AbstractTriggerCommand<S, C> {
    public RecQuantizationCommand(IModel model, S surface) {
        super(model, surface);
    }

    @Override
    public void execute(ButtonEvent event, int velocity) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        ITransport transport = this.model.getTransport();
        if (this.surface.isSelectPressed()) {
            transport.nextLaunchQuantization();
            this.mvHelper.delayDisplay(() -> transport.getAutomationWriteMode().getLabel());
            return;
        }
        boolean isShift = this.surface.isShiftPressed();
        boolean flipRecord = this.surface.getConfiguration().isFlipRecord();
        if (isShift && !flipRecord || !isShift && flipRecord) {
            transport.toggleWriteClipLauncherAutomation();
        } else {
            transport.toggleWriteArrangerAutomation();
        }
    }

    public boolean isLit() {
        boolean isShift = this.surface.isShiftPressed();
        boolean flipRecord = this.surface.getConfiguration().isFlipRecord();
        ITransport transport = this.model.getTransport();
        if (isShift && !flipRecord || !isShift && flipRecord) {
            return transport.isWritingClipLauncherAutomation();
        }
        return transport.isWritingArrangerAutomation();
    }
}

