/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.command.trigger.transport;

import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.command.trigger.clip.NewCommand;
import de.mossgrabers.framework.configuration.AbstractConfiguration;
import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.ITransport;
import de.mossgrabers.framework.daw.data.ISlot;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.utils.ButtonEvent;
import java.util.Optional;

public class ConfiguredRecordCommand<S extends IControlSurface<C>, C extends Configuration>
extends AbstractTriggerCommand<S, C> {
    private final ShiftMode shiftMode;

    public ConfiguredRecordCommand(IModel model, S surface) {
        super(model, surface);
        this.shiftMode = ShiftMode.CALC_SHIFT;
    }

    public ConfiguredRecordCommand(boolean isShifted, IModel model, S surface) {
        super(model, surface);
        this.shiftMode = isShifted ? ShiftMode.SHIFTED : ShiftMode.NO_SHIFT;
    }

    @Override
    public void execute(ButtonEvent event, int velocity) {
        if (event != ButtonEvent.UP) {
            return;
        }
        Object configuration = this.surface.getConfiguration();
        AbstractConfiguration.RecordFunction recordMode = this.isShifted() ? configuration.getShiftedRecordButtonFunction() : configuration.getRecordButtonFunction();
        ITransport transport = this.model.getTransport();
        switch (recordMode) {
            case RECORD_ARRANGER: {
                transport.startRecording();
                break;
            }
            case RECORD_ARRANGER_AND_ENABLE_AUTOMATION: {
                if (!transport.isWritingArrangerAutomation()) {
                    transport.toggleWriteArrangerAutomation();
                }
                transport.startRecording();
                break;
            }
            case RECORD_CLIP: {
                this.createClip();
                break;
            }
            case RECORD_CLIP_AND_ENABLE_AUTOMATION: {
                this.createClip();
                if (transport.isWritingClipLauncherAutomation()) break;
                transport.toggleWriteClipLauncherAutomation();
                break;
            }
            case NEW_CLIP: {
                new NewCommand(this.model, this.surface).execute();
                break;
            }
            case NEW_CLIP_AND_ENABLE_AUTOMATION: {
                new NewCommand(this.model, this.surface).execute();
                if (transport.isWritingClipLauncherAutomation()) break;
                transport.toggleWriteClipLauncherAutomation();
                break;
            }
            case TOGGLE_ARRANGER_OVERDUB: {
                transport.toggleOverdub();
                break;
            }
            case TOGGLE_CLIP_OVERDUB: {
                transport.toggleLauncherOverdub();
                break;
            }
            case TOGGLE_REC_ARM: {
                Optional selectedTrack = this.model.getCurrentTrackBank().getSelectedItem();
                if (!selectedTrack.isPresent()) break;
                ((ITrack)selectedTrack.get()).toggleRecArm();
                break;
            }
        }
    }

    private void createClip() {
        Optional<ISlot> slot = this.model.getSelectedSlot();
        if (slot.isEmpty()) {
            return;
        }
        ISlot s = slot.get();
        if (!s.isRecording()) {
            s.startRecording();
        }
        s.launch(true, false);
    }

    private boolean isShifted() {
        switch (this.shiftMode.ordinal()) {
            case 1: {
                return true;
            }
            case 0: {
                return false;
            }
        }
        return this.surface.isShiftPressed();
    }

    public boolean isLit() {
        return this.isLit(this.isShifted());
    }

    public boolean isLit(boolean isShifted) {
        Object configuration = this.surface.getConfiguration();
        AbstractConfiguration.RecordFunction recordMode = isShifted ? configuration.getShiftedRecordButtonFunction() : configuration.getRecordButtonFunction();
        switch (recordMode) {
            case RECORD_ARRANGER: 
            case RECORD_ARRANGER_AND_ENABLE_AUTOMATION: {
                return this.model.getTransport().isRecording();
            }
            case RECORD_CLIP: 
            case RECORD_CLIP_AND_ENABLE_AUTOMATION: 
            case NEW_CLIP: 
            case NEW_CLIP_AND_ENABLE_AUTOMATION: {
                Optional<ISlot> slot = this.model.getSelectedSlot();
                if (slot.isEmpty()) {
                    return false;
                }
                ISlot s = slot.get();
                return s.isRecording();
            }
            case TOGGLE_ARRANGER_OVERDUB: {
                return this.model.getTransport().isArrangerOverdub();
            }
            case TOGGLE_CLIP_OVERDUB: {
                return this.model.getTransport().isLauncherOverdub();
            }
            case TOGGLE_REC_ARM: {
                Optional selectedTrack = this.model.getCurrentTrackBank().getSelectedItem();
                return selectedTrack.isPresent() && ((ITrack)selectedTrack.get()).isRecArm();
            }
        }
        return false;
    }

    private static enum ShiftMode {
        NO_SHIFT,
        SHIFTED,
        CALC_SHIFT;

    }
}

