/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.command.core;

import de.mossgrabers.framework.MVHelper;
import de.mossgrabers.framework.command.core.TriggerCommand;
import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ICursorTrack;
import de.mossgrabers.framework.featuregroup.ViewManager;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.Views;

public abstract class AbstractTriggerCommand<S extends IControlSurface<C>, C extends Configuration>
implements TriggerCommand {
    protected final IModel model;
    protected final S surface;
    protected final MVHelper<S, C> mvHelper;

    protected AbstractTriggerCommand(IModel model, S surface) {
        this.model = model;
        this.surface = surface;
        this.mvHelper = new MVHelper(model, surface);
    }

    @Override
    public void execute(ButtonEvent event, int velocity) {
        if (this.surface.isShiftPressed()) {
            this.executeShifted(event);
        } else {
            this.executeNormal(event);
        }
    }

    public void executeNormal(ButtonEvent event) {
    }

    public void executeShifted(ButtonEvent event) {
    }

    protected void activatePreferredView(Views viewID) {
        if (viewID == null) {
            return;
        }
        ViewManager viewManager = this.surface.getViewManager();
        if (viewManager.get(viewID) == null) {
            return;
        }
        viewManager.setActive(viewID);
        ICursorTrack cursorTrack = this.model.getCursorTrack();
        if (cursorTrack.doesExist()) {
            viewManager.setPreferredView(cursorTrack.getPosition(), viewID);
        }
    }
}

