/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework;

import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.controller.display.IDisplay;
import de.mossgrabers.framework.daw.GrooveParameterID;
import de.mossgrabers.framework.daw.IGroove;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.ITransport;
import de.mossgrabers.framework.daw.clip.INoteClip;
import de.mossgrabers.framework.daw.constants.DeviceID;
import de.mossgrabers.framework.daw.data.ICursorDevice;
import de.mossgrabers.framework.daw.data.IDrumDevice;
import de.mossgrabers.framework.daw.data.ILayer;
import de.mossgrabers.framework.daw.data.IScene;
import de.mossgrabers.framework.daw.data.ISend;
import de.mossgrabers.framework.daw.data.ISpecificDevice;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.IDrumPadBank;
import de.mossgrabers.framework.daw.data.bank.ILayerBank;
import de.mossgrabers.framework.daw.data.bank.IParameterBank;
import de.mossgrabers.framework.daw.data.bank.ISceneBank;
import de.mossgrabers.framework.daw.data.bank.ISendBank;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import de.mossgrabers.framework.featuregroup.IMode;
import de.mossgrabers.framework.parameter.IParameter;
import de.mossgrabers.framework.scale.Scales;
import java.util.Optional;
import java.util.function.Supplier;

public class MVHelper<S extends IControlSurface<C>, C extends Configuration> {
    private static final String SELECTED_TRACK_NONE = "Selected track: None";
    private static final String NONE = "None";
    private static final int DISPLAY_DELAY = 200;
    private final IModel model;
    private final ITransport transport;
    private final IGroove groove;
    private final S surface;
    private final IDisplay display;

    public MVHelper(IModel model, S surface) {
        this.model = model;
        this.surface = surface;
        this.display = this.surface == null ? null : this.surface.getDisplay();
        this.transport = this.model == null ? null : this.model.getTransport();
        this.groove = this.model == null ? null : this.model.getGroove();
    }

    public void notifySelectedTrack() {
        this.delayDisplay(() -> {
            ITrackBank currentTrackBank = this.model.getCurrentTrackBank();
            Optional selectedTrack = currentTrackBank.getSelectedItem();
            if (selectedTrack.isEmpty()) {
                return SELECTED_TRACK_NONE;
            }
            ITrack t = (ITrack)selectedTrack.get();
            if (!t.doesExist()) {
                return SELECTED_TRACK_NONE;
            }
            return t.getPosition() + 1 + ": " + t.getName();
        });
    }

    public void notifyTrackRange() {
        this.delayDisplay(() -> {
            ITrackBank currentTrackBank = this.model.getCurrentTrackBank();
            int scrollPosition = currentTrackBank.getScrollPosition();
            return "Tracks: " + (scrollPosition + 1) + "-" + (scrollPosition + currentTrackBank.getPageSize());
        });
    }

    public void notifyLayerRange() {
        this.delayDisplay(() -> {
            ISpecificDevice specificDevice = this.model.getSpecificDevice(DeviceID.FIRST_INSTRUMENT);
            ILayerBank layerBank = specificDevice.getLayerBank();
            int scrollPosition = layerBank.getScrollPosition();
            if (specificDevice.hasLayers() && scrollPosition >= 0) {
                return "Layers: " + (scrollPosition + 1) + "-" + (scrollPosition + layerBank.getPageSize());
            }
            return "";
        });
    }

    public void notifyDrumPadRange() {
        this.delayDisplay(() -> {
            IDrumDevice specificDevice = this.model.getDrumDevice();
            IDrumPadBank drumPadBank = specificDevice.getDrumPadBank();
            int scrollPosition = drumPadBank.getScrollPosition();
            if (specificDevice.hasDrumPads() && scrollPosition >= 0) {
                return "Drum Pads: " + scrollPosition + "-" + (scrollPosition + drumPadBank.getPageSize());
            }
            return "";
        });
    }

    public void notifySelectedSends(ISendBank sendBank) {
        this.delayDisplay(() -> {
            int scrollPosition = sendBank.getScrollPosition() + 1;
            return "Sends: " + scrollPosition + "-" + (scrollPosition + 1);
        });
    }

    public void notifySelectedSend(int sendIndex) {
        this.delayDisplay(() -> {
            ISend send;
            ITrackBank trackBank = this.model.getTrackBank();
            Optional selectedTrack = trackBank.getSelectedItem();
            if (selectedTrack.isEmpty()) {
                ITrack item = (ITrack)trackBank.getItem(0);
                selectedTrack = item.doesExist() ? Optional.of(item) : Optional.empty();
            }
            String sendModeName = "Send " + (sendIndex + 1) + ": ";
            sendModeName = selectedTrack.isPresent() ? sendModeName + ((send = (ISend)((ITrack)selectedTrack.get()).getSendBank().getItem(sendIndex)).doesExist() ? send.getName() : "-") : sendModeName + "-";
            return sendModeName;
        });
    }

    public void notifySelectedDevice() {
        this.delayDisplay(() -> {
            ICursorDevice cursorDevice = this.model.getCursorDevice();
            return "Selected device: " + (cursorDevice.doesExist() ? cursorDevice.getName() : NONE);
        });
    }

    public void notifySelectedLayer() {
        ICursorDevice cursorDevice = this.model.getCursorDevice();
        if (!cursorDevice.doesExist() || !cursorDevice.hasLayers()) {
            return;
        }
        this.delayDisplay(() -> {
            Optional selectedLayer = cursorDevice.getLayerBank().getSelectedItem();
            return "Selected layer: " + (selectedLayer.isPresent() ? ((ILayer)selectedLayer.get()).getName() : NONE);
        });
    }

    public void notifySelectedDeviceAndParameterPage() {
        this.delayDisplay(() -> {
            ICursorDevice cursorDevice = this.model.getCursorDevice();
            if (!cursorDevice.doesExist()) {
                return "No device selected";
            }
            Object text = cursorDevice.getName();
            Optional selectedItem = cursorDevice.getParameterBank().getPageBank().getSelectedItem();
            if (selectedItem.isPresent()) {
                String pageName = (String)selectedItem.get();
                if (pageName == null || pageName.isBlank()) {
                    pageName = NONE;
                }
                text = (String)text + " - " + pageName;
            }
            return text;
        });
    }

    public void notifyFirstDeviceAndParameterPage() {
        this.delayDisplay(() -> {
            Optional selectedItem;
            ISpecificDevice cursorDevice = this.model.getSpecificDevice(DeviceID.FIRST_INSTRUMENT);
            if (cursorDevice.doesExist() && (selectedItem = cursorDevice.getParameterBank().getPageBank().getSelectedItem()).isPresent()) {
                return cursorDevice.getName() + " - " + (String)selectedItem.get();
            }
            return "No device selected";
        });
    }

    public void notifySelectedParameterPage() {
        ICursorDevice cursorDevice = this.model.getCursorDevice();
        if (cursorDevice.doesExist()) {
            this.notifySelectedParameterPage(cursorDevice.getParameterBank(), "");
        }
    }

    public void notifySelectedProjectParameterPage() {
        this.notifySelectedParameterPage(this.model.getProject().getParameterBank(), "Project ");
    }

    public void notifySelectedTrackParameterPage() {
        this.notifySelectedParameterPage(this.model.getCursorTrack().getParameterBank(), "Track ");
    }

    public void notifySelectedParameterPage(IParameterBank bank, String prefix) {
        this.delayDisplay(() -> {
            String name;
            Optional selectedItem = bank.getPageBank().getSelectedItem();
            if (selectedItem.isPresent() && !(name = (String)selectedItem.get()).isBlank()) {
                return prefix + "Page: " + name;
            }
            return prefix + "Page: None";
        });
    }

    public void notifyParameter(IParameter parameter) {
        if (parameter.doesExist()) {
            this.delayDisplay(() -> parameter.getName() + ": " + parameter.getDisplayedValue());
        }
    }

    public void notifySelectedItem(IMode mode) {
        this.delayDisplay(() -> {
            Optional<String> selectedItemName = mode.getSelectedItemName();
            return selectedItemName.isPresent() ? selectedItemName.get() : NONE;
        });
    }

    public void notifyScenePage() {
        this.delayDisplay(() -> {
            ISceneBank sceneBank = this.model.getSceneBank();
            int lastScene = -1;
            for (int i = sceneBank.getPageSize() - 1; i >= 0; --i) {
                if (!((IScene)sceneBank.getItem(i)).doesExist()) continue;
                lastScene = i;
                break;
            }
            if (lastScene == -1) {
                return "No scenes";
            }
            IScene first = (IScene)sceneBank.getItem(0);
            String firstText = String.format("%d: %s", first.getPosition() + 1, first.getName());
            if (lastScene == 0) {
                return firstText;
            }
            IScene last = (IScene)sceneBank.getItem(lastScene);
            return firstText + String.format(" - %d: %s", last.getPosition() + 1, last.getName());
        });
    }

    public void notifyTempo() {
        this.delayDisplay(() -> "Tempo: " + this.transport.formatTempo(this.transport.getTempo()));
    }

    public void notifyGrooveEnablement() {
        this.delayDisplay(() -> "Groove: " + (this.groove.getParameter(GrooveParameterID.ENABLED).getValue() == 0 ? "Off" : "On"));
    }

    public void notifyShuffle() {
        this.delayDisplay(() -> "Shuffle: " + this.groove.getParameter(GrooveParameterID.SHUFFLE_AMOUNT).getDisplayedValue());
    }

    public void notifyArrangerRepeat() {
        this.delayDisplay(() -> "Repeat: " + (this.transport.isLoop() ? "On" : "Off"));
    }

    public void notifyMetronome() {
        this.delayDisplay(() -> "Metronome: " + (this.transport.isMetronomeOn() ? "On" : "Off"));
    }

    public void notifyMetronomeTicks() {
        this.delayDisplay(() -> "Ticks: " + (this.transport.isMetronomeTicksOn() ? "On" : "Off"));
    }

    public void notifyPlayPosition() {
        this.delayDisplay(() -> "Play Pos.: " + this.transport.getBeatText());
    }

    public void notifyEditPage(INoteClip clip) {
        if (clip != null && clip.doesExist()) {
            this.delayDisplay(() -> "Edit page: " + (clip.getEditPage() + 1));
        }
    }

    public void notifyScale(Scales scales) {
        this.delayDisplay(() -> "Scale: " + scales.getScale().getName());
    }

    public void notifyClipLauncherAutomation() {
        this.delayDisplay(() -> "Lnchr Autom.: " + (this.transport.isWritingClipLauncherAutomation() ? "On" : "Off"));
    }

    public void notifyArrangerAutomation() {
        this.delayDisplay(() -> "Arr. Autom.: " + (this.transport.isWritingArrangerAutomation() ? "On" : "Off"));
    }

    public void notifyAutomationWriteMode() {
        this.delayDisplay(() -> "Autom.: " + this.transport.getAutomationWriteMode().getLabel());
    }

    public void delayDisplay(Supplier<String> supplier) {
        this.surface.scheduleTask(() -> {
            String message = (String)supplier.get();
            if (message != null && !message.isBlank()) {
                this.display.notify(message);
            }
        }, 200L);
    }
}

