/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.osc.protocol;

import de.mossgrabers.controller.osc.OSCConfiguration;
import de.mossgrabers.controller.osc.module.IModule;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.osc.AbstractOpenSoundControlWriter;
import de.mossgrabers.framework.osc.IOpenSoundControlClient;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class OSCWriter
extends AbstractOpenSoundControlWriter {
    private static final Set<String> HEARTBEAT_MESSAGES = new HashSet<String>(3);
    private final List<IModule> modules = new ArrayList<IModule>();

    public OSCWriter(IHost host, IModel model, IOpenSoundControlClient oscClient, OSCConfiguration configuration) {
        super(host, model, oscClient, configuration);
    }

    @Override
    public void flush(boolean dump) {
        if (!this.isConnected()) {
            return;
        }
        this.modules.forEach(module -> module.flush(dump));
        this.flush("/update");
    }

    @Override
    protected boolean isHeartbeatMessage(String address) {
        return HEARTBEAT_MESSAGES.contains(address);
    }

    public void registerModule(IModule module) {
        this.modules.add(module);
    }

    static {
        HEARTBEAT_MESSAGES.add("/update");
        HEARTBEAT_MESSAGES.add("/time/str");
        HEARTBEAT_MESSAGES.add("/beat/str");
    }
}

