/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.sl;

import de.mossgrabers.framework.controller.DefaultControllerDefinition;
import de.mossgrabers.framework.utils.OperatingSystem;
import de.mossgrabers.framework.utils.Pair;
import java.util.List;
import java.util.UUID;

public class SLControllerDefinition
extends DefaultControllerDefinition {
    private static final UUID EXTENSION_ID_MK_I = UUID.fromString("A9041F50-0407-11E5-B939-0800200C9A66");
    private static final UUID EXTENSION_ID_MK_II = UUID.fromString("D1CEE920-1E51-11E4-8C21-0800200C9A66");
    private final boolean isMkII;

    public SLControllerDefinition(boolean isMkII) {
        super(isMkII ? EXTENSION_ID_MK_II : EXTENSION_ID_MK_I, isMkII ? "SL MkII" : "SL MkI", "Novation", 2, 1);
        this.isMkII = isMkII;
    }

    @Override
    public List<Pair<String[], String[]>> getMidiDiscoveryPairs(OperatingSystem os) {
        List<Pair<String[], String[]>> midiDiscoveryPairs = super.getMidiDiscoveryPairs(os);
        if (this.isMkII) {
            switch (os) {
                case WINDOWS: {
                    midiDiscoveryPairs.add(this.addDeviceDiscoveryPair(new String[]{"MIDIIN2 (SL MkII)", "SL MkII"}, new String[]{"MIDIOUT2 (SL MkII)"}));
                    break;
                }
                case MAC: 
                case MAC_ARM: {
                    midiDiscoveryPairs.add(this.addDeviceDiscoveryPair(new String[]{"SL MkII MIDI 2", "SL MkII MIDI 1"}, new String[]{"SL MkII MIDI 2"}));
                    break;
                }
                default: {
                    midiDiscoveryPairs.add(this.addDeviceDiscoveryPair(new String[]{"MIDIIN2 (SL MkII)", "SL MkII"}, new String[]{"MIDIOUT2 (SL MkII)"}));
                    midiDiscoveryPairs.add(this.addDeviceDiscoveryPair(new String[]{"SL MkII MIDI 2", "SL MkII MIDI 1"}, new String[]{"SL MkII MIDI 2"}));
                }
            }
            return midiDiscoveryPairs;
        }
        midiDiscoveryPairs.add(this.addDeviceDiscoveryPair(new String[]{"ReMOTE SL Port 2", "ReMOTE SL Port 1"}, new String[]{"ReMOTE SL Port 2"}));
        return midiDiscoveryPairs;
    }
}

