/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.launchpad.view;

import de.mossgrabers.controller.novation.launchpad.LaunchpadConfiguration;
import de.mossgrabers.controller.novation.launchpad.controller.LaunchpadControlSurface;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.grid.IPadGrid;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.featuregroup.AbstractView;
import de.mossgrabers.framework.featuregroup.IView;
import de.mossgrabers.framework.featuregroup.ViewManager;
import de.mossgrabers.framework.view.Views;

public class NoteViewSelectView
extends AbstractView<LaunchpadControlSurface, LaunchpadConfiguration> {
    public NoteViewSelectView(LaunchpadControlSurface surface, IModel model) {
        super("View select", surface, model);
    }

    @Override
    public void drawGrid() {
        int i;
        ViewManager viewManager = ((LaunchpadControlSurface)this.surface).getViewManager();
        Views previousViewId = (Views)((Object)viewManager.getPreviousID());
        IPadGrid padGrid = ((LaunchpadControlSurface)this.surface).getPadGrid();
        for (i = 36; i < 44; ++i) {
            padGrid.light(i, 0);
        }
        padGrid.light(44, previousViewId == Views.CLIP_LENGTH ? 22 : 54);
        for (i = 45; i < 60; ++i) {
            padGrid.light(i, 0);
        }
        padGrid.light(60, previousViewId == Views.SEQUENCER ? 22 : 14);
        padGrid.light(61, previousViewId == Views.POLY_SEQUENCER ? 22 : 14);
        padGrid.light(62, previousViewId == Views.RAINDROPS ? 22 : 14);
        for (i = 63; i < 76; ++i) {
            padGrid.light(i, 0);
        }
        padGrid.light(76, previousViewId == Views.DRUM ? 22 : 46);
        padGrid.light(77, previousViewId == Views.DRUM4 ? 22 : 46);
        padGrid.light(78, previousViewId == Views.DRUM8 ? 22 : 46);
        for (i = 79; i < 92; ++i) {
            padGrid.light(i, 0);
        }
        padGrid.light(92, previousViewId == Views.PLAY ? 22 : 10);
        padGrid.light(93, previousViewId == Views.PIANO ? 22 : 10);
        padGrid.light(94, previousViewId == Views.DRUM64 ? 22 : 10);
        for (i = 95; i < 100; ++i) {
            padGrid.light(i, 0);
        }
    }

    @Override
    public void onGridNote(int note, int velocity) {
        Views viewID;
        if (velocity != 0) {
            return;
        }
        switch (note) {
            case 92: {
                viewID = Views.PLAY;
                break;
            }
            case 93: {
                viewID = Views.PIANO;
                break;
            }
            case 94: {
                viewID = Views.DRUM64;
                break;
            }
            case 76: {
                viewID = Views.DRUM;
                break;
            }
            case 77: {
                viewID = Views.DRUM4;
                break;
            }
            case 78: {
                viewID = Views.DRUM8;
                break;
            }
            case 60: {
                viewID = Views.SEQUENCER;
                break;
            }
            case 61: {
                viewID = Views.POLY_SEQUENCER;
                break;
            }
            case 62: {
                viewID = Views.RAINDROPS;
                break;
            }
            case 44: {
                viewID = Views.CLIP_LENGTH;
                break;
            }
            default: {
                return;
            }
        }
        this.activatePreferredView(viewID);
        ((LaunchpadControlSurface)this.surface).getDisplay().notify(((IView)((LaunchpadControlSurface)this.surface).getViewManager().get(viewID)).getName());
    }

    @Override
    public int getButtonColor(ButtonID buttonID) {
        return 22;
    }
}

