/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.launchpad.view;

import de.mossgrabers.controller.novation.launchpad.LaunchpadConfiguration;
import de.mossgrabers.controller.novation.launchpad.controller.LaunchpadControlSurface;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.clip.INoteClip;
import de.mossgrabers.framework.daw.clip.NotePosition;
import de.mossgrabers.framework.featuregroup.IScrollableView;
import de.mossgrabers.framework.featuregroup.ViewManager;
import de.mossgrabers.framework.utils.ScrollStates;
import de.mossgrabers.framework.view.sequencer.AbstractDrum8View;
import de.mossgrabers.framework.view.sequencer.AbstractDrumView;

public class Drum8View
extends AbstractDrum8View<LaunchpadControlSurface, LaunchpadConfiguration>
implements IScrollableView {
    private NotePosition noteEditPosition;

    public Drum8View(LaunchpadControlSurface surface, IModel model) {
        super(surface, model, true);
    }

    @Override
    public void onGridNoteLongPress(int note) {
        if (!this.isActive()) {
            return;
        }
        int index = note - ((LaunchpadControlSurface)this.surface).getPadGrid().getStartNote();
        int x = index % this.numColumns;
        int y = index / this.numColumns;
        int sound = y % this.lanes + this.scales.getDrumOffset();
        int laneOffset = (this.allRows - 1 - y) / this.lanes * this.numColumns;
        this.noteEditPosition = new NotePosition(this.configuration.getMidiEditChannel(), laneOffset + x, sound);
    }

    @Override
    protected void handleSequencerArea(int velocity, int downVelocity, NotePosition notePosition) {
        if (velocity != 0) {
            this.noteEditPosition = null;
            return;
        }
        if (this.noteEditPosition != null) {
            this.editNote(this.getClip(), this.noteEditPosition, false);
        } else {
            super.handleSequencerArea(velocity, downVelocity, notePosition);
        }
    }

    @Override
    protected boolean handleSequencerAreaButtonCombinations(INoteClip clip, NotePosition notePosition, int row, int velocity, int accentVelocity) {
        boolean isUpPressed = ((LaunchpadControlSurface)this.surface).isPressed(ButtonID.UP);
        if (isUpPressed || ((LaunchpadControlSurface)this.surface).isPressed(ButtonID.DOWN)) {
            ((LaunchpadControlSurface)this.surface).setTriggerConsumed(isUpPressed ? ButtonID.UP : ButtonID.DOWN);
            if (velocity > 0) {
                this.handleSequencerAreaRepeatOperator(clip, notePosition, velocity, isUpPressed);
            }
            return true;
        }
        return super.handleSequencerAreaButtonCombinations(clip, notePosition, row, velocity, accentVelocity);
    }

    @Override
    public void updateScrollStates(ScrollStates scrollStates) {
        ViewManager viewManager = ((LaunchpadControlSurface)this.surface).getViewManager();
        INoteClip drumClip = ((AbstractDrumView)AbstractDrumView.class.cast(viewManager.getActive())).getClip();
        scrollStates.setCanScrollLeft(drumClip.canScrollStepsBackwards());
        scrollStates.setCanScrollRight(drumClip.canScrollStepsForwards());
        scrollStates.setCanScrollUp(this.scales.canScrollDrumOctaveUp());
        scrollStates.setCanScrollDown(this.scales.canScrollDrumOctaveDown());
    }
}

