/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.launchpad.definition;

import de.mossgrabers.controller.novation.launchpad.definition.AbstractLaunchpadDefinition;
import de.mossgrabers.framework.utils.OperatingSystem;
import de.mossgrabers.framework.utils.Pair;
import java.util.List;
import java.util.Optional;
import java.util.UUID;

public class LaunchpadXControllerDefinition
extends AbstractLaunchpadDefinition {
    private static final UUID EXTENSION_ID = UUID.fromString("CD196CCF-DF98-4AB0-9ABC-F0F29A60ACED");
    private static final String SYSEX_HEADER = "F0 00 20 29 02 0C ";
    private static final Optional<String> BRIGHTNESS_SYSEX = Optional.of("F0 00 20 29 02 0C 08 %02X F7");

    public LaunchpadXControllerDefinition() {
        super(EXTENSION_ID, "Launchpad X");
    }

    @Override
    public List<Pair<String[], String[]>> getMidiDiscoveryPairs(OperatingSystem os) {
        List<Pair<String[], String[]>> midiDiscoveryPairs = super.getMidiDiscoveryPairs(os);
        switch (os) {
            case WINDOWS: {
                midiDiscoveryPairs.addAll(this.createWindowsDeviceDiscoveryPairs("MIDIIN2 (%sLPX MIDI)", "MIDIOUT2 (%sLPX MIDI)"));
                break;
            }
            case LINUX: {
                midiDiscoveryPairs.add(this.addDeviceDiscoveryPair("Launchpad X MIDI 2", "Launchpad X MIDI 2"));
                midiDiscoveryPairs.add(this.addDeviceDiscoveryPair("Launchpad X LPX MIDI Out", "Launchpad X LPX MIDI In"));
                break;
            }
            case MAC: 
            case MAC_ARM: {
                midiDiscoveryPairs.add(this.addDeviceDiscoveryPair("Launchpad X LPX MIDI Out", "Launchpad X LPX MIDI In"));
                break;
            }
        }
        return midiDiscoveryPairs;
    }

    @Override
    public String getSysExHeader() {
        return SYSEX_HEADER;
    }

    @Override
    public String getStandaloneModeCommand() {
        return "10 00";
    }

    @Override
    public String getProgramModeCommand() {
        return "0E 01";
    }

    @Override
    public Optional<String> getBrightnessSysex() {
        return BRIGHTNESS_SYSEX;
    }
}

