/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.launchkey.maxi.view;

import de.mossgrabers.controller.novation.launchkey.maxi.LaunchkeyMk3Configuration;
import de.mossgrabers.controller.novation.launchkey.maxi.controller.LaunchkeyMk3ControlSurface;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.daw.IBrowser;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ICursorDevice;
import de.mossgrabers.framework.featuregroup.AbstractView;
import de.mossgrabers.framework.featuregroup.ViewManager;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.Views;
import java.util.EnumMap;
import java.util.Map;

public class BrowserView
extends AbstractView<LaunchkeyMk3ControlSurface, LaunchkeyMk3Configuration> {
    private static final Map<Views, Integer> VIEW_COMMANDS = new EnumMap<Views, Integer>(Views.class);

    public BrowserView(LaunchkeyMk3ControlSurface surface, IModel model) {
        super("Browser", surface, model);
    }

    @Override
    public void onGridNote(int note, int velocity) {
    }

    @Override
    public void drawGrid() {
    }

    @Override
    public int getButtonColor(ButtonID buttonID) {
        IBrowser browser = this.model.getBrowser();
        switch (buttonID) {
            case SCENE1: {
                return 21;
            }
            case SCENE2: {
                return 7;
            }
            case ARROW_UP: {
                return browser.isActive() && browser.hasNextContentType() ? 23 : 1;
            }
            case ARROW_DOWN: {
                return browser.isActive() && browser.hasPreviousContentType() ? 23 : 1;
            }
        }
        return 0;
    }

    @Override
    public void onButton(ButtonID buttonID, ButtonEvent event, int velocity) {
        if (event != ButtonEvent.UP) {
            return;
        }
        IBrowser browser = this.model.getBrowser();
        if (!browser.isActive()) {
            return;
        }
        switch (buttonID) {
            case SCENE1: {
                this.confirmBrowser(browser, true);
                break;
            }
            case SCENE2: {
                this.confirmBrowser(browser, false);
                break;
            }
            case ARROW_UP: {
                browser.nextContentType();
                break;
            }
            case ARROW_DOWN: {
                browser.previousContentType();
                break;
            }
        }
    }

    protected void confirmBrowser(IBrowser browser, boolean commitSelection) {
        browser.stopBrowsing(commitSelection);
    }

    @Override
    public void onActivate() {
        IBrowser browser = this.model.getBrowser();
        if (browser.isActive()) {
            ((LaunchkeyMk3ControlSurface)this.surface).getMidiOutput().sendCCEx(15, 3, 10);
        } else {
            ICursorDevice cursorDevice = this.model.getCursorDevice();
            if (((LaunchkeyMk3ControlSurface)this.surface).isShiftPressed() || !cursorDevice.doesExist()) {
                browser.insertAfterCursorDevice();
            } else {
                browser.replace(cursorDevice);
            }
        }
        super.onActivate();
    }

    @Override
    public void onDeactivate() {
        ViewManager viewManager;
        Views activeID;
        IBrowser browser = this.model.getBrowser();
        if (browser.isActive()) {
            browser.stopBrowsing(false);
        }
        if ((activeID = (Views)((Object)(viewManager = ((LaunchkeyMk3ControlSurface)this.surface).getViewManager()).getActiveID())) == Views.BROWSER) {
            ((LaunchkeyMk3ControlSurface)this.surface).getButton(ButtonID.BROWSE).clearState();
            Views previousID = (Views)((Object)viewManager.getActiveIDIgnoreTemporary());
            Integer id = VIEW_COMMANDS.get((Object)previousID);
            int viewCommand = id == null || previousID == Views.BROWSER ? 2 : id;
            ((LaunchkeyMk3ControlSurface)this.surface).getMidiOutput().sendCCEx(15, 3, viewCommand);
        }
    }

    static {
        VIEW_COMMANDS.put(Views.SESSION, 2);
        VIEW_COMMANDS.put(Views.DRUM, 1);
        VIEW_COMMANDS.put(Views.DUMMY1, 3);
        VIEW_COMMANDS.put(Views.DUMMY2, 4);
        VIEW_COMMANDS.put(Views.DUMMY3, 5);
        VIEW_COMMANDS.put(Views.DUMMY4, 6);
        VIEW_COMMANDS.put(Views.DUMMY5, 7);
        VIEW_COMMANDS.put(Views.DUMMY6, 8);
        VIEW_COMMANDS.put(Views.DEVICE, 9);
        VIEW_COMMANDS.put(Views.BROWSER, 10);
    }
}

