/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ni.maschine.jam.view;

import de.mossgrabers.controller.ni.maschine.core.command.trigger.EncoderMode;
import de.mossgrabers.controller.ni.maschine.core.view.IMaschineView;
import de.mossgrabers.controller.ni.maschine.jam.MaschineJamConfiguration;
import de.mossgrabers.controller.ni.maschine.jam.controller.MaschineJamControlSurface;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.clip.INoteClip;
import de.mossgrabers.framework.daw.clip.NotePosition;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.sequencer.AbstractDrum8View;

public class Drum8View
extends AbstractDrum8View<MaschineJamControlSurface, MaschineJamConfiguration>
implements IMaschineView {
    public Drum8View(MaschineJamControlSurface surface, IModel model) {
        super(surface, model, true);
    }

    @Override
    public void changeOption(EncoderMode temporaryEncoderMode, int control) {
        this.keyManager.clearPressedKeys();
        boolean increase = this.model.getValueChanger().isIncrease(control);
        switch (temporaryEncoderMode) {
            case TEMPORARY_PERFORM: {
                break;
            }
            case TEMPORARY_NOTES: {
                break;
            }
            case TEMPORARY_LOCK: {
                break;
            }
            case TEMPORARY_TUNE: {
                if (increase) {
                    this.onOctaveUp(ButtonEvent.DOWN);
                    break;
                }
                this.onOctaveDown(ButtonEvent.DOWN);
                break;
            }
        }
    }

    @Override
    public void onButton(ButtonID buttonID, ButtonEvent event, int velocity) {
        switch (buttonID) {
            case ARROW_LEFT: {
                this.onLeft(event);
                break;
            }
            case ARROW_RIGHT: {
                this.onRight(event);
                break;
            }
            case ARROW_UP: {
                this.onOctaveUp(event);
                break;
            }
            case ARROW_DOWN: {
                this.onOctaveDown(event);
                break;
            }
            default: {
                super.onButton(buttonID, event, velocity);
            }
        }
    }

    @Override
    protected boolean handleSequencerAreaButtonCombinations(INoteClip clip, NotePosition notePosition, int row, int velocity, int accentVelocity) {
        boolean isSelectPressed = ((MaschineJamControlSurface)this.surface).isSelectPressed();
        if (isSelectPressed) {
            if (velocity > 0) {
                this.handleSequencerAreaRepeatOperator(clip, notePosition, velocity, isSelectPressed);
            }
            return true;
        }
        return super.handleSequencerAreaButtonCombinations(clip, notePosition, row, velocity, accentVelocity);
    }

    @Override
    public boolean wasAlternateInteractionUsed() {
        return false;
    }

    @Override
    public void setAlternateInteractionUsed(boolean wasUsed) {
    }
}

