/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.mackie.mcu.command.trigger;

import de.mossgrabers.controller.mackie.mcu.controller.MCUControlSurface;
import de.mossgrabers.framework.featuregroup.IMode;
import de.mossgrabers.framework.featuregroup.ModeManager;
import de.mossgrabers.framework.mode.Modes;
import java.util.EnumMap;
import java.util.Map;

public class ModeSwitcher {
    private final MCUControlSurface surface;
    private static final Map<Modes, Modes> PREV_MODES = new EnumMap<Modes, Modes>(Modes.class);
    private static final Map<Modes, Modes> NEXT_MODES = new EnumMap<Modes, Modes>(Modes.class);

    public ModeSwitcher(MCUControlSurface surface) {
        this.surface = surface;
    }

    public void scrollUp() {
        ModeManager modeManager = this.surface.getModeManager();
        modeManager.setActive(PREV_MODES.getOrDefault(modeManager.getActiveID(), Modes.PAN));
        this.surface.getHost().showNotification(((IMode)modeManager.getActive()).getName());
    }

    public void scrollDown() {
        ModeManager modeManager = this.surface.getModeManager();
        modeManager.setActive(NEXT_MODES.getOrDefault(modeManager.getActiveID(), Modes.TRACK));
        this.surface.getHost().showNotification(((IMode)modeManager.getActive()).getName());
    }

    static {
        PREV_MODES.put(Modes.PAN, Modes.VOLUME);
        PREV_MODES.put(Modes.VOLUME, Modes.TRACK);
        PREV_MODES.put(Modes.TRACK, Modes.DEVICE_PARAMS);
        PREV_MODES.put(Modes.DEVICE_PARAMS, Modes.PAN);
        NEXT_MODES.put(Modes.TRACK, Modes.VOLUME);
        NEXT_MODES.put(Modes.VOLUME, Modes.PAN);
        NEXT_MODES.put(Modes.PAN, Modes.DEVICE_PARAMS);
        NEXT_MODES.put(Modes.DEVICE_PARAMS, Modes.TRACK);
    }
}

