/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.mackie.hui.controller;

import de.mossgrabers.framework.controller.display.AbstractTextDisplay;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.midi.IMidiOutput;
import de.mossgrabers.framework.utils.LatestTaskExecutor;
import de.mossgrabers.framework.utils.StringUtils;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class HUIDisplay
extends AbstractTextDisplay {
    private static final String SYSEX_DISPLAY_HEADER = "F0 00 00 66 05 00 10 ";
    private final LatestTaskExecutor executor = new LatestTaskExecutor();

    public HUIDisplay(IHost host, IMidiOutput output) {
        super(host, output, 1, 9, 36);
        this.centerNotification = false;
    }

    @Override
    public void writeLine(int row, String text, String previousText) {
        if (this.executor.isShutdown()) {
            return;
        }
        this.executor.execute(() -> {
            try {
                this.sendDisplayLine(text);
            }
            catch (RuntimeException ex) {
                this.host.error("Could not send line to HUI display.", ex);
            }
        });
    }

    private void sendDisplayLine(String text) {
        String t = text;
        int[] array = new int[5];
        for (int cell = 0; cell < this.noOfCells; ++cell) {
            array[0] = cell;
            for (int i = 0; i < 4; ++i) {
                array[1 + i] = t.charAt(cell * 4 + i);
            }
            this.output.sendSysex(SYSEX_DISPLAY_HEADER + StringUtils.toHexStr(array) + "F7");
        }
    }

    @Override
    public void shutdown() {
        this.notifyOnDisplay("Please start " + this.host.getName() + "...");
        ExecutorService shutdownExecutor = Executors.newSingleThreadExecutor();
        shutdownExecutor.execute(() -> {
            this.executor.shutdown();
            try {
                if (!this.executor.awaitTermination(5L, TimeUnit.SECONDS)) {
                    this.host.error("HUI display send executor did not end in 5 seconds.");
                }
            }
            catch (InterruptedException ex) {
                this.host.error("HUI display send executor interrupted.", ex);
                Thread.currentThread().interrupt();
            }
        });
        shutdownExecutor.shutdown();
        try {
            if (!shutdownExecutor.awaitTermination(10L, TimeUnit.SECONDS)) {
                this.host.error("HUI display shutdown executor did not end in 10 seconds.");
            }
        }
        catch (InterruptedException ex) {
            this.host.error("Display shutdown interrupted.", ex);
            Thread.currentThread().interrupt();
        }
    }
}

