/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.intuitiveinstruments.exquis;

import de.mossgrabers.framework.configuration.AbstractConfiguration;
import de.mossgrabers.framework.configuration.ISettingsUI;
import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.midi.ArpeggiatorMode;
import java.util.List;

public class ExquisConfiguration
extends AbstractConfiguration {
    public static final String[] EXQUISE_SCALES = new String[]{"Major", "Natural Minor", "Melodic Minor", "Harmonic Minor", "Dorian", "Phrygian", "Lydian", "Mixolydian", "Locrian", "Phrygian dominant", "Major Pentatonic", "Minor Pentatonic", "Whole Tone", "Chromatic"};

    public ExquisConfiguration(IHost host, IValueChanger valueChanger, List<ArpeggiatorMode> arpeggiatorModes) {
        super(host, valueChanger, arpeggiatorModes);
    }

    @Override
    public void init(ISettingsUI globalSettings, ISettingsUI documentSettings) {
        this.activateMPEBendRange(documentSettings, "Pads");
        this.activateScaleSetting(documentSettings, EXQUISE_SCALES, EXQUISE_SCALES[0]);
        this.activateScaleBaseSetting(documentSettings);
        this.activateNoteRepeatSetting(documentSettings);
        this.activateSelectClipOnLaunchSetting(globalSettings);
        this.activateDrawRecordStripeSetting(globalSettings);
        this.activateActionForRecArmedPad(globalSettings);
        this.activateBehaviourOnPauseSetting(globalSettings);
        this.activateExcludeDeactivatedItemsSetting(globalSettings);
        this.activateNewClipLengthSetting(globalSettings);
        this.activateKnobSpeedSetting(globalSettings, 100, 20, true);
    }
}

