/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.generic.flexihandler;

import de.mossgrabers.controller.generic.GenericFlexiConfiguration;
import de.mossgrabers.controller.generic.controller.FlexiCommand;
import de.mossgrabers.controller.generic.controller.GenericFlexiControlSurface;
import de.mossgrabers.controller.generic.flexihandler.AbstractHandler;
import de.mossgrabers.controller.generic.flexihandler.utils.FlexiHandlerException;
import de.mossgrabers.controller.generic.flexihandler.utils.KnobMode;
import de.mossgrabers.controller.generic.flexihandler.utils.MidiValue;
import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IScene;
import de.mossgrabers.framework.daw.data.bank.ISceneBank;

public class SceneHandler
extends AbstractHandler {
    public SceneHandler(IModel model, GenericFlexiControlSurface surface, GenericFlexiConfiguration configuration, IValueChanger absoluteLowResValueChanger, IValueChanger signedBitRelativeValueChanger, IValueChanger signedBit2RelativeValueChanger, IValueChanger offsetBinaryRelativeValueChanger) {
        super(model, surface, configuration, absoluteLowResValueChanger, signedBitRelativeValueChanger, signedBit2RelativeValueChanger, offsetBinaryRelativeValueChanger);
    }

    @Override
    public FlexiCommand[] getSupportedCommands() {
        return new FlexiCommand[]{FlexiCommand.SCENE_1_LAUNCH_SCENE, FlexiCommand.SCENE_2_LAUNCH_SCENE, FlexiCommand.SCENE_3_LAUNCH_SCENE, FlexiCommand.SCENE_4_LAUNCH_SCENE, FlexiCommand.SCENE_5_LAUNCH_SCENE, FlexiCommand.SCENE_6_LAUNCH_SCENE, FlexiCommand.SCENE_7_LAUNCH_SCENE, FlexiCommand.SCENE_8_LAUNCH_SCENE, FlexiCommand.SCENE_1_LAUNCH_ALT_SCENE, FlexiCommand.SCENE_2_LAUNCH_ALT_SCENE, FlexiCommand.SCENE_3_LAUNCH_ALT_SCENE, FlexiCommand.SCENE_4_LAUNCH_ALT_SCENE, FlexiCommand.SCENE_5_LAUNCH_ALT_SCENE, FlexiCommand.SCENE_6_LAUNCH_ALT_SCENE, FlexiCommand.SCENE_7_LAUNCH_ALT_SCENE, FlexiCommand.SCENE_8_LAUNCH_ALT_SCENE, FlexiCommand.SCENE_SELECT_PREVIOUS_BANK, FlexiCommand.SCENE_SELECT_NEXT_BANK, FlexiCommand.SCENE_SCROLL_BANK_PAGE_BY_1_LEFT, FlexiCommand.SCENE_SCROLL_BANK_PAGE_BY_1_RIGHT, FlexiCommand.SCENE_CREATE_SCENE, FlexiCommand.SCENE_CREATE_SCENE_FROM_PLAYING_CLIPS};
    }

    @Override
    public int getCommandValue(FlexiCommand command) {
        ISceneBank sceneBank = this.model.getSceneBank();
        switch (command) {
            case SCENE_SELECT_PREVIOUS_BANK: {
                return SceneHandler.toMidiValue(sceneBank.canScrollPageBackwards());
            }
            case SCENE_SELECT_NEXT_BANK: {
                return SceneHandler.toMidiValue(sceneBank.canScrollPageForwards());
            }
            case SCENE_SCROLL_BANK_PAGE_BY_1_LEFT: {
                return SceneHandler.toMidiValue(sceneBank.canScrollBackwards());
            }
            case SCENE_SCROLL_BANK_PAGE_BY_1_RIGHT: {
                return SceneHandler.toMidiValue(sceneBank.canScrollForwards());
            }
        }
        return -1;
    }

    @Override
    public void handle(FlexiCommand command, KnobMode knobMode, MidiValue value) {
        boolean isButtonPressed = this.isButtonPressed(knobMode, value);
        ISceneBank sceneBank = this.model.getSceneBank();
        switch (command) {
            case SCENE_1_LAUNCH_SCENE: 
            case SCENE_2_LAUNCH_SCENE: 
            case SCENE_3_LAUNCH_SCENE: 
            case SCENE_4_LAUNCH_SCENE: 
            case SCENE_5_LAUNCH_SCENE: 
            case SCENE_6_LAUNCH_SCENE: 
            case SCENE_7_LAUNCH_SCENE: 
            case SCENE_8_LAUNCH_SCENE: {
                if (!isButtonPressed) break;
                IScene scene = (IScene)sceneBank.getItem(command.ordinal() - FlexiCommand.SCENE_1_LAUNCH_SCENE.ordinal());
                scene.select();
                scene.launch(isButtonPressed, false);
                break;
            }
            case SCENE_1_LAUNCH_ALT_SCENE: 
            case SCENE_2_LAUNCH_ALT_SCENE: 
            case SCENE_3_LAUNCH_ALT_SCENE: 
            case SCENE_4_LAUNCH_ALT_SCENE: 
            case SCENE_5_LAUNCH_ALT_SCENE: 
            case SCENE_6_LAUNCH_ALT_SCENE: 
            case SCENE_7_LAUNCH_ALT_SCENE: 
            case SCENE_8_LAUNCH_ALT_SCENE: {
                if (!isButtonPressed) break;
                IScene scene = (IScene)sceneBank.getItem(command.ordinal() - FlexiCommand.SCENE_1_LAUNCH_ALT_SCENE.ordinal());
                scene.select();
                scene.launch(isButtonPressed, true);
                break;
            }
            case SCENE_SELECT_PREVIOUS_BANK: {
                if (!isButtonPressed) break;
                sceneBank.selectPreviousPage();
                break;
            }
            case SCENE_SELECT_NEXT_BANK: {
                if (!isButtonPressed) break;
                sceneBank.selectNextPage();
                break;
            }
            case SCENE_SCROLL_BANK_PAGE_BY_1_LEFT: {
                if (!isButtonPressed) break;
                sceneBank.scrollBackwards();
                break;
            }
            case SCENE_SCROLL_BANK_PAGE_BY_1_RIGHT: {
                if (!isButtonPressed) break;
                sceneBank.scrollForwards();
                break;
            }
            case SCENE_CREATE_SCENE: {
                if (!isButtonPressed) break;
                this.model.getProject().createScene();
                break;
            }
            case SCENE_CREATE_SCENE_FROM_PLAYING_CLIPS: {
                if (!isButtonPressed) break;
                this.model.getProject().createSceneFromPlayingLauncherClips();
                break;
            }
            default: {
                throw new FlexiHandlerException(command);
            }
        }
    }
}

