/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.generic.controller;

import de.mossgrabers.controller.generic.GenericFlexiConfiguration;
import de.mossgrabers.controller.generic.controller.FlexiCommand;
import de.mossgrabers.controller.generic.flexihandler.IFlexiCommandHandler;
import de.mossgrabers.controller.generic.flexihandler.utils.CommandSlot;
import de.mossgrabers.controller.generic.flexihandler.utils.KnobMode;
import de.mossgrabers.controller.generic.flexihandler.utils.MidiValue;
import de.mossgrabers.framework.controller.AbstractControlSurface;
import de.mossgrabers.framework.controller.color.ColorManager;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.midi.IMidiInput;
import de.mossgrabers.framework.daw.midi.IMidiOutput;
import de.mossgrabers.framework.featuregroup.IMode;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.utils.StringUtils;
import de.mossgrabers.nativefiledialogs.FileFilter;
import de.mossgrabers.nativefiledialogs.NativeFileDialogs;
import de.mossgrabers.nativefiledialogs.NativeFileDialogsFactory;
import de.mossgrabers.nativefiledialogs.PlatformNotSupported;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class GenericFlexiControlSurface
extends AbstractControlSurface<GenericFlexiConfiguration> {
    private static final FileFilter[] FILE_FILTERS = new FileFilter[]{new FileFilter("Configuration", new String[]{"properties"}), new FileFilter("All files", new String[]{"*"})};
    private final int[] valueCache = new int[300];
    private final Map<FlexiCommand, IFlexiCommandHandler> handlers = new EnumMap<FlexiCommand, IFlexiCommandHandler>(FlexiCommand.class);
    private NativeFileDialogs dialogs;
    private long lastReceived = 0L;
    private int lastCCReceived = -1;
    private final int[] lastCCValues = new int[128];
    private boolean isShiftPressed = false;
    private boolean isUpdatingValue = false;
    private int functionLayer = 0;
    private int previousFunctionLayer = 0;

    public GenericFlexiControlSurface(IHost host, GenericFlexiConfiguration configuration, ColorManager colorManager, IMidiOutput output, IMidiInput input) {
        super(host, configuration, colorManager, output, input, null, 10.0, 10.0);
        try {
            this.dialogs = NativeFileDialogsFactory.create(null);
        }
        catch (PlatformNotSupported ex) {
            this.host.error("Could not create dialogs instance.", ex);
        }
        Arrays.fill(this.valueCache, -1);
        ((GenericFlexiConfiguration)this.configuration).addSettingObserver(GenericFlexiConfiguration.BUTTON_SAVE, this::saveFile);
        ((GenericFlexiConfiguration)this.configuration).addSettingObserver(GenericFlexiConfiguration.BUTTON_LOAD, this::loadAndSelectFile);
        this.input.setSysexCallback(this::handleSysEx);
    }

    public void registerHandler(IFlexiCommandHandler handler) {
        Arrays.asList(handler.getSupportedCommands()).forEach(command -> this.handlers.put((FlexiCommand)((Object)command), handler));
    }

    @Override
    public void flush() {
        CommandSlot[] slots = ((GenericFlexiConfiguration)this.configuration).getCommandSlots();
        for (int i = 0; i < slots.length; ++i) {
            FlexiCommand command = slots[i].getCommand();
            if (command == FlexiCommand.OFF || !slots[i].isSendValue()) continue;
            this.flushValue(i, slots[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushValue(int index, CommandSlot slot) {
        FlexiCommand command = slot.getCommand();
        if (!(!this.isUpdatingValue || command.isTrigger() && slot.isSendValueWhenReceived())) {
            return;
        }
        int value = this.getCommandValue(command);
        int[] nArray = this.valueCache;
        synchronized (this.valueCache) {
            if (this.valueCache[index] == value) {
                // ** MonitorExit[var5_5] (shouldn't be in output)
                return;
            }
            this.valueCache[index] = value;
            // ** MonitorExit[var5_5] (shouldn't be in output)
            this.reflectValue(slot, value);
            return;
        }
    }

    @Override
    public boolean isShiftPressed() {
        return this.isShiftPressed;
    }

    public void activateMode(Modes modeID) {
        String modeName = ((IMode)this.modeManager.get(modeID)).getName();
        if (!this.modeManager.isActive(new Modes[]{modeID})) {
            this.modeManager.setActive(modeID);
            this.host.showNotification(modeName);
        }
        if (!modeName.equals(((GenericFlexiConfiguration)this.configuration).getSelectedModeName())) {
            ((GenericFlexiConfiguration)this.configuration).setSelectedMode(modeName);
        }
    }

    public void setShiftPressed(boolean isShiftPressed) {
        this.isShiftPressed = isShiftPressed;
    }

    public void updateKeyTranslation() {
        this.setKeyTranslationTable(((GenericFlexiConfiguration)this.configuration).getNoteMap());
    }

    @Override
    protected void handleMidi(int status, int data1, int data2) {
        int code = status & 0xF0;
        int channel = status & 0xF;
        switch (code) {
            case 128: 
            case 144: {
                ((GenericFlexiConfiguration)this.configuration).setLearnValues(GenericFlexiConfiguration.OPTIONS_TYPE.get(2), data1, channel, false);
                MidiValue midiValue = MidiValue.get(code == 128 ? 0 : data2, false);
                this.handleCommand(this.processFunctionLayer(((GenericFlexiConfiguration)this.configuration).getSlotCommands(1, data1, channel), midiValue), midiValue);
                break;
            }
            case 192: {
                this.handleProgramChange(channel, data1);
                break;
            }
            case 176: {
                this.handleCC(channel, data1, data2);
                break;
            }
            case 224: {
                ((GenericFlexiConfiguration)this.configuration).setLearnValues(GenericFlexiConfiguration.OPTIONS_TYPE.get(4), data1, channel, true);
                MidiValue value = MidiValue.get(data1 + data2 * 128, true);
                this.handleCommand(this.processFunctionLayer(((GenericFlexiConfiguration)this.configuration).getSlotCommands(3, data1, channel), value), value);
                break;
            }
        }
    }

    private CommandSlot processFunctionLayer(List<CommandSlot> commandSlots, MidiValue value) {
        for (CommandSlot commandSlot : commandSlots) {
            int fl;
            FlexiCommand command = commandSlot.getCommand();
            int functionOrdinal = command.ordinal();
            if (functionOrdinal < FlexiCommand.FUNCTION_LAYER1.ordinal() || functionOrdinal > FlexiCommand.FUNCTION_LAYER10_TEMP.ordinal() || (fl = commandSlot.getFunctionLayer()) >= 0 && fl != this.functionLayer) continue;
            this.switchFunctionLayer(commandSlot, value);
            return null;
        }
        for (CommandSlot slot : commandSlots) {
            int fl = slot.getFunctionLayer();
            if (fl >= 0 && fl != this.functionLayer) continue;
            return slot;
        }
        return null;
    }

    @Override
    protected void handleCC(int channel, int data1, int data2) {
        long now = System.currentTimeMillis();
        boolean isRelated = now - this.lastReceived < 1000L;
        boolean isHighRes = isRelated && this.lastCCReceived < 32 && this.lastCCReceived + 32 == data1;
        this.lastCCReceived = data1;
        this.lastReceived = now;
        this.lastCCValues[data1] = data2;
        ((GenericFlexiConfiguration)this.configuration).setLearnValues(GenericFlexiConfiguration.OPTIONS_TYPE.get(1), data1, channel, isHighRes);
        int value = 0;
        boolean isHighResValue = false;
        CommandSlot matchedCommandSlot = null;
        if (data1 >= 0 && data1 < 32) {
            for (CommandSlot commandSlot : ((GenericFlexiConfiguration)this.configuration).getSlotCommands(0, data1, channel)) {
                int fl = commandSlot.getFunctionLayer();
                if (fl >= 0 && (fl != this.functionLayer || !commandSlot.getResolution())) continue;
                matchedCommandSlot = commandSlot;
                value = data2 * 128 + this.lastCCValues[data1 + 32];
                isHighResValue = true;
            }
        } else if (data1 >= 32 && data1 < 64) {
            int firstCC = data1 - 32;
            for (CommandSlot commandSlot : ((GenericFlexiConfiguration)this.configuration).getSlotCommands(0, firstCC, channel)) {
                if (commandSlot.getFunctionLayer() != this.functionLayer || !commandSlot.getResolution()) continue;
                matchedCommandSlot = commandSlot;
                value = this.lastCCValues[firstCC] * 128 + data2;
                isHighResValue = true;
            }
        }
        ArrayList<CommandSlot> commandSlots = new ArrayList<CommandSlot>();
        if (matchedCommandSlot == null) {
            for (CommandSlot commandSlot : ((GenericFlexiConfiguration)this.configuration).getSlotCommands(0, data1, channel)) {
                commandSlots.add(commandSlot);
                value = data2;
            }
        } else {
            commandSlots.add(matchedCommandSlot);
        }
        MidiValue midiValue = MidiValue.get(value, isHighResValue);
        this.handleCommand(this.processFunctionLayer(commandSlots, midiValue), midiValue);
    }

    private void handleProgramChange(int channel, int data1) {
        ((GenericFlexiConfiguration)this.configuration).setLearnValues(GenericFlexiConfiguration.OPTIONS_TYPE.get(3), data1, channel, false);
        CommandSlot commandSlot = this.processFunctionLayer(((GenericFlexiConfiguration)this.configuration).getSlotCommands(2, data1, channel), MidiValue.get(127, false));
        if (commandSlot == null) {
            return;
        }
        if (commandSlot.getCommand().isTrigger()) {
            this.handleCommand(commandSlot, MidiValue.get(127, false));
            this.handleCommand(commandSlot, MidiValue.get(0, false));
        } else {
            this.handleCommand(commandSlot, MidiValue.get(data1, false));
        }
    }

    private void handleSysEx(String dataStr) {
        int[] data = StringUtils.fromHexStr(dataStr);
        if (data.length != 6 || data[0] != 240 || data[1] != 127 || data[3] != 6 || data[5] != 247) {
            return;
        }
        int channel = data[2] % 16;
        int number = data[4];
        ((GenericFlexiConfiguration)this.configuration).setLearnValues(GenericFlexiConfiguration.OPTIONS_TYPE.get(5), number, channel, false);
        CommandSlot commandSlot = this.processFunctionLayer(((GenericFlexiConfiguration)this.configuration).getSlotCommands(4, number, channel), MidiValue.get(127, false));
        if (commandSlot == null) {
            return;
        }
        this.handleCommand(commandSlot, MidiValue.get(127, false));
        this.handleCommand(commandSlot, MidiValue.get(0, false));
    }

    public void loadAndSelectFile() {
        Optional<String> filename = this.getFileName(false);
        if (filename.isPresent()) {
            this.host.showNotification(this.loadFile(filename.get()));
        }
    }

    public String loadFile(String filename) {
        if (filename == null || filename.isBlank()) {
            return "No file name set.";
        }
        File file = new File(filename);
        if (!file.exists()) {
            return "The entered file does not exist: " + file.getAbsolutePath();
        }
        try {
            ((GenericFlexiConfiguration)this.configuration).importFrom(file);
            this.updateKeyTranslation();
            return "Imported from: " + String.valueOf(file);
        }
        catch (IOException ex) {
            return "Error reading file: " + ex.getMessage();
        }
    }

    private void saveFile() {
        Optional<String> filenameOpt = this.getFileName(true);
        if (filenameOpt.isEmpty()) {
            return;
        }
        try {
            Object filename = filenameOpt.get();
            if (!((String)filename).endsWith(".properties")) {
                filename = (String)filename + ".properties";
                ((GenericFlexiConfiguration)this.configuration).setFilename((String)filename);
            }
            ((GenericFlexiConfiguration)this.configuration).exportTo(new File((String)filename));
            this.host.showNotification("Exported to: " + (String)filename);
        }
        catch (IOException ex) {
            this.host.showNotification("Error writing file: " + ex.getMessage());
        }
    }

    private Optional<String> getFileName(boolean isNew) {
        File currentFolder;
        String filename = ((GenericFlexiConfiguration)this.configuration).getFilename();
        if (filename != null && !filename.isBlank() && (currentFolder = new File(filename)).exists()) {
            this.dialogs.setCurrentDirectory(currentFolder);
        }
        try {
            File fn;
            File file = fn = isNew ? this.dialogs.selectNewFile("Save", FILE_FILTERS) : this.dialogs.selectFile("Load", FILE_FILTERS);
            if (fn == null) {
                return Optional.empty();
            }
            filename = fn.getAbsolutePath();
            ((GenericFlexiConfiguration)this.configuration).setFilename(filename);
            return Optional.of(filename);
        }
        catch (IOException ex) {
            this.host.error("Could not create file dialog.", ex);
            return Optional.empty();
        }
    }

    private int getCommandValue(FlexiCommand command) {
        IFlexiCommandHandler commandHandler = this.handlers.get((Object)command);
        if (commandHandler == null) {
            return -1;
        }
        int value = commandHandler.getCommandValue(command);
        return (int)Math.round((double)value * 127.0 / 16383.0);
    }

    private void handleCommand(CommandSlot commandSlot, MidiValue value) {
        if (commandSlot == null) {
            return;
        }
        this.isUpdatingValue = true;
        FlexiCommand command = commandSlot.getCommand();
        IFlexiCommandHandler commandHandler = this.handlers.get((Object)command);
        if (commandHandler == null) {
            this.host.error("No handler registered for command: " + String.valueOf((Object)command));
            return;
        }
        commandHandler.handle(command, commandSlot.getKnobMode(), value);
        this.host.scheduleTask(() -> {
            this.isUpdatingValue = false;
        }, 400L);
    }

    private void reflectValue(CommandSlot slot, int value) {
        if (value < 0 || value > 127) {
            this.host.error(String.format("Attempt to reflect value out of range from slot command: %s Value: %d", slot.getCommand().getName(), value));
            return;
        }
        IMidiOutput output = this.getMidiOutput();
        int midiChannel = slot.getMidiChannel();
        if (midiChannel > 15) {
            return;
        }
        switch (slot.getType()) {
            case 1: {
                output.sendNoteEx(midiChannel, slot.getNumber(), value);
                break;
            }
            case 0: {
                output.sendCCEx(midiChannel, slot.getNumber(), value);
                break;
            }
            case 3: {
                output.sendPitchbend(midiChannel, 0, value);
                break;
            }
        }
    }

    private void switchFunctionLayer(CommandSlot commandSlot, MidiValue value) {
        FlexiCommand command = commandSlot.getCommand();
        KnobMode knobMode = commandSlot.getKnobMode();
        int oldLayer = this.functionLayer;
        switch (command) {
            case FUNCTION_LAYER1: 
            case FUNCTION_LAYER2: 
            case FUNCTION_LAYER3: 
            case FUNCTION_LAYER4: 
            case FUNCTION_LAYER5: 
            case FUNCTION_LAYER6: 
            case FUNCTION_LAYER7: 
            case FUNCTION_LAYER8: 
            case FUNCTION_LAYER9: 
            case FUNCTION_LAYER10: {
                if (knobMode != KnobMode.ABSOLUTE_TOGGLE && (knobMode != KnobMode.ABSOLUTE || !value.isPositive())) break;
                this.functionLayer = command.ordinal() - FlexiCommand.FUNCTION_LAYER1.ordinal();
                break;
            }
            case FUNCTION_LAYER2_TEMP: 
            case FUNCTION_LAYER3_TEMP: 
            case FUNCTION_LAYER4_TEMP: 
            case FUNCTION_LAYER5_TEMP: 
            case FUNCTION_LAYER6_TEMP: 
            case FUNCTION_LAYER7_TEMP: 
            case FUNCTION_LAYER8_TEMP: 
            case FUNCTION_LAYER9_TEMP: 
            case FUNCTION_LAYER10_TEMP: {
                int layerIndex = command.ordinal() - FlexiCommand.FUNCTION_LAYER2_TEMP.ordinal() + 1;
                if (knobMode == KnobMode.ABSOLUTE_TOGGLE && this.functionLayer != layerIndex || knobMode == KnobMode.ABSOLUTE && value.isPositive()) {
                    this.previousFunctionLayer = oldLayer;
                    this.functionLayer = layerIndex;
                    break;
                }
                this.functionLayer = this.previousFunctionLayer;
                break;
            }
            default: {
                return;
            }
        }
        if (oldLayer != this.functionLayer) {
            this.getHost().showNotification("Functions Layer " + (this.functionLayer + 1));
        }
    }
}

