/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ableton.push.mode.track;

import de.mossgrabers.controller.ableton.push.PushConfiguration;
import de.mossgrabers.controller.ableton.push.controller.Push1Display;
import de.mossgrabers.controller.ableton.push.controller.PushControlSurface;
import de.mossgrabers.controller.ableton.push.mode.track.AbstractTrackMode;
import de.mossgrabers.controller.ableton.push.parameterprovider.PushTrackParameterProvider;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.controller.display.Format;
import de.mossgrabers.framework.controller.display.IGraphicDisplay;
import de.mossgrabers.framework.controller.display.ITextDisplay;
import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ICursorTrack;
import de.mossgrabers.framework.daw.data.ISend;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.ISendBank;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import de.mossgrabers.framework.graphics.canvas.utils.SendData;
import de.mossgrabers.framework.parameter.IParameter;
import de.mossgrabers.framework.utils.Pair;
import java.util.Optional;

public class TrackMode
extends AbstractTrackMode {
    public TrackMode(PushControlSurface surface, IModel model) {
        super("Track", surface, model);
        this.setParameterProvider(new PushTrackParameterProvider(model, (PushConfiguration)surface.getConfiguration()));
    }

    @Override
    public void onKnobTouch(int index, boolean isTouched) {
        IParameter iParameter;
        super.onKnobTouch(index, isTouched);
        if (isTouched && ((PushControlSurface)this.surface).isShiftPressed() && ((PushControlSurface)this.surface).isSelectPressed() && (iParameter = this.getParameterProvider().get(index)) instanceof ISend) {
            ISend send = (ISend)iParameter;
            ((PushControlSurface)this.surface).setTriggerConsumed(ButtonID.SELECT);
            send.toggleEnabled();
        }
    }

    @Override
    public void updateDisplay1(ITextDisplay display) {
        ITrackBank tb = this.model.getCurrentTrackBank();
        Optional track = tb.getSelectedItem();
        if (track.isEmpty()) {
            display.setRow(1, "                     Please selecta track...                        ");
        } else {
            ITrack t = (ITrack)track.get();
            PushConfiguration config = (PushConfiguration)((PushControlSurface)this.surface).getConfiguration();
            int upperBound = this.model.getValueChanger().getUpperBound();
            String volValueStr = config.isEnableVUMeters() ? Push1Display.formatValue(t.getVolume(), t.getVu(), upperBound) : Push1Display.formatValue(t.getVolume(), upperBound);
            display.setCell(0, 0, "Volume").setCell(1, 0, t.getVolumeStr(8)).setCell(2, 0, volValueStr);
            display.setCell(0, 1, "Pan").setCell(1, 1, t.getPanStr(8)).setCell(2, 1, t.getPan(), Format.FORMAT_PAN);
            int sendStart = 2;
            int sendCount = 6;
            ISendBank sendBank = t.getSendBank();
            for (int i = 0; i < 6; ++i) {
                int pos = 2 + i;
                ISend send = (ISend)sendBank.getItem(i);
                if (!send.doesExist()) continue;
                display.setCell(0, pos, send.getName()).setCell(1, pos, send.getDisplayedValue(8)).setCell(2, pos, send.getValue(), Format.FORMAT_VALUE);
            }
        }
        this.drawRow4(display);
    }

    @Override
    public void updateDisplay2(IGraphicDisplay display) {
        int sendsIndex;
        ITrackBank tb = this.model.getCurrentTrackBank();
        Optional selectedTrack = tb.getSelectedItem();
        int selectedIndex = selectedTrack.isEmpty() ? -1 : ((ITrack)selectedTrack.get()).getIndex();
        int n = sendsIndex = selectedTrack.isEmpty() ? -1 : ((ITrack)selectedTrack.get()).getIndex() + 1;
        if (sendsIndex == 8) {
            sendsIndex = 6;
        }
        this.updateMenuItems(0);
        ICursorTrack cursorTrack = this.model.getCursorTrack();
        PushConfiguration config = (PushConfiguration)((PushControlSurface)this.surface).getConfiguration();
        for (int i = 0; i < 8; ++i) {
            ITrack t = (ITrack)tb.getItem(i);
            Pair pair = (Pair)this.menu.get(i);
            String topMenu = (String)pair.getKey();
            boolean topMenuSelected = (Boolean)pair.getValue();
            String bottomMenu = t.doesExist() ? t.getName() : "";
            ColorEx bottomMenuColor = t.getColor();
            boolean isBottomMenuOn = t.isSelected();
            IValueChanger valueChanger = this.model.getValueChanger();
            if (t.isSelected()) {
                int crossfadeMode = this.getCrossfadeModeAsNumber(t);
                boolean enableVUMeters = config.isEnableVUMeters();
                int vuR = valueChanger.toDisplayValue(enableVUMeters ? t.getVuRight() : 0);
                int vuL = valueChanger.toDisplayValue(enableVUMeters ? t.getVuLeft() : 0);
                display.addChannelElement(topMenu, topMenuSelected, bottomMenu, this.updateType(t), bottomMenuColor, isBottomMenuOn, valueChanger.toDisplayValue(t.getVolume()), valueChanger.toDisplayValue(t.getModulatedVolume()), this.isKnobTouched(0) ? t.getVolumeStr(8) : "", valueChanger.toDisplayValue(t.getPan()), valueChanger.toDisplayValue(t.getModulatedPan()), this.isKnobTouched(1) ? t.getPanStr(8) : "", vuL, vuR, t.isMute(), t.isSolo(), t.isRecArm(), t.isActivated(), crossfadeMode, cursorTrack.isPinned());
                continue;
            }
            if (sendsIndex == i) {
                ITrack selTrack = (ITrack)tb.getItem(selectedIndex);
                SendData[] sendData = new SendData[4];
                for (int j = 0; j < 4; ++j) {
                    ISend send;
                    if (selTrack != null && (send = (ISend)selTrack.getSendBank().getItem(j)) != null) {
                        boolean exists = send.doesExist();
                        sendData[j] = new SendData(send.isEnabled(), send.getName(), exists && this.isKnobTouched(4 + j) ? send.getDisplayedValue(8) : "", valueChanger.toDisplayValue(exists ? send.getValue() : 0), valueChanger.toDisplayValue(exists ? send.getModulatedValue() : 0), true);
                        continue;
                    }
                    sendData[j] = new SendData(false, "", "", 0, 0, true);
                }
                display.addSendsElement(topMenu, topMenuSelected, bottomMenu, this.updateType(t), bottomMenuColor, isBottomMenuOn, sendData, true, selTrack == null || selTrack.isActivated(), t.isActivated());
                continue;
            }
            display.addChannelSelectorElement(topMenu, topMenuSelected, bottomMenu, this.updateType(t), bottomMenuColor, isBottomMenuOn, t.isActivated());
        }
    }
}

