/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ableton.push.mode.track;

import de.mossgrabers.controller.ableton.push.controller.PushControlSurface;
import de.mossgrabers.controller.ableton.push.mode.track.AbstractTrackMode;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.display.Format;
import de.mossgrabers.framework.controller.display.IGraphicDisplay;
import de.mossgrabers.framework.controller.display.ITextDisplay;
import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ISend;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.ISendBank;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import de.mossgrabers.framework.graphics.canvas.utils.SendData;
import de.mossgrabers.framework.parameter.IParameter;
import de.mossgrabers.framework.parameterprovider.track.SendParameterProvider;
import de.mossgrabers.framework.utils.Pair;

public class SendMode
extends AbstractTrackMode {
    private final int sendIndex;

    public SendMode(PushControlSurface surface, IModel model, int sendIndex) {
        super("Send", surface, model);
        this.sendIndex = sendIndex;
        this.setParameterProvider(new SendParameterProvider(model, this.sendIndex, 0));
    }

    @Override
    public void onKnobTouch(int index, boolean isTouched) {
        IParameter iParameter;
        super.onKnobTouch(index, isTouched);
        if (isTouched && ((PushControlSurface)this.surface).isShiftPressed() && ((PushControlSurface)this.surface).isSelectPressed() && (iParameter = this.getParameterProvider().get(index)) instanceof ISend) {
            ISend send = (ISend)iParameter;
            ((PushControlSurface)this.surface).setTriggerConsumed(ButtonID.SELECT);
            send.toggleEnabled();
        }
    }

    @Override
    public void updateDisplay1(ITextDisplay display) {
        ITrackBank tb = this.model.getCurrentTrackBank();
        for (int i = 0; i < 8; ++i) {
            ITrack t = (ITrack)tb.getItem(i);
            if (!t.doesExist()) continue;
            ISend send = (ISend)t.getSendBank().getItem(this.sendIndex);
            display.setCell(0, i, send.getName());
            display.setCell(1, i, send.getDisplayedValue(8));
            display.setCell(2, i, send.getValue(), Format.FORMAT_VALUE);
        }
        this.drawRow4(display);
    }

    @Override
    public void updateDisplay2(IGraphicDisplay display) {
        this.updateTrackMenu(5 + this.sendIndex % 4);
        ITrackBank tb = this.model.getCurrentTrackBank();
        IValueChanger valueChanger = this.model.getValueChanger();
        for (int i = 0; i < 8; ++i) {
            ITrack t = (ITrack)tb.getItem(i);
            ISendBank sendBank = t.getSendBank();
            SendData[] sendData = new SendData[4];
            for (int j = 0; j < 4; ++j) {
                ISend send = (ISend)sendBank.getItem(j);
                boolean exists = send != null && send.doesExist();
                sendData[j] = new SendData(send.isEnabled(), exists ? send.getName() : "", exists && this.sendIndex == j && this.isKnobTouched(i) ? send.getDisplayedValue(8) : "", valueChanger.toDisplayValue(exists ? send.getValue() : -1), valueChanger.toDisplayValue(exists ? send.getModulatedValue() : -1), this.sendIndex == j);
            }
            Pair pair = (Pair)this.menu.get(i);
            display.addSendsElement((String)pair.getKey(), (Boolean)pair.getValue(), t.doesExist() ? t.getName() : "", this.updateType(t), t.getColor(), t.isSelected(), sendData, false, t.isActivated(), t.isActivated());
        }
    }
}

