/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ableton.push.mode.track;

import de.mossgrabers.controller.ableton.push.command.continuous.IPush3Encoder;
import de.mossgrabers.controller.ableton.push.controller.PushControlSurface;
import de.mossgrabers.controller.ableton.push.mode.track.AbstractTrackMode;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.display.IGraphicDisplay;
import de.mossgrabers.framework.controller.display.ITextDisplay;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.ITransport;
import de.mossgrabers.framework.daw.clip.IClip;
import de.mossgrabers.framework.daw.clip.INoteClip;
import de.mossgrabers.framework.daw.clip.NotePosition;
import de.mossgrabers.framework.daw.constants.Capability;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import de.mossgrabers.framework.featuregroup.IView;
import de.mossgrabers.framework.featuregroup.ViewManager;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.utils.StringUtils;
import de.mossgrabers.framework.view.ColorSelectMode;
import de.mossgrabers.framework.view.ColorView;
import de.mossgrabers.framework.view.Views;
import de.mossgrabers.framework.view.sequencer.AbstractSequencerView;

public class ClipMode
extends AbstractTrackMode
implements IPush3Encoder {
    private static final String PLEASE_SELECT_A_CLIP_PUSH1 = "      Pleaseselect a clip.";
    private static final String PLEASE_SELECT_A_CLIP_PUSH2 = "Please select a clip.";
    private boolean displayMidiNotes = false;
    private NotePosition activeNotePosition = null;
    private final ITransport transport = this.model.getTransport();

    public ClipMode(PushControlSurface surface, IModel model) {
        super("Clip", surface, model);
    }

    @Override
    public void onKnobTouch(int index, boolean isTouched) {
        this.setTouchedKnob(index, isTouched);
        if (index == 7 && isTouched && ((PushControlSurface)this.surface).isDeletePressed()) {
            ((PushControlSurface)this.surface).setTriggerConsumed(ButtonID.DELETE);
            IClip clip = this.getMidiClip();
            if (clip.doesExist()) {
                clip.resetAccent();
            }
        }
    }

    @Override
    public void onKnobValue(int index, int value) {
        if (!this.increaseKnobMovement()) {
            return;
        }
        IClip clip = this.getMidiClip();
        if (!clip.doesExist()) {
            return;
        }
        boolean shiftPressed = ((PushControlSurface)this.surface).isShiftPressed();
        switch (index) {
            case 0: {
                clip.changePlayStart(value, shiftPressed);
                break;
            }
            case 1: {
                clip.changePlayEnd(value, shiftPressed);
                break;
            }
            case 2: {
                clip.changeLoopStart(value, shiftPressed);
                break;
            }
            case 3: {
                clip.changeLoopLength(value, shiftPressed);
                break;
            }
            case 4: {
                clip.setLoopEnabled(value <= 61);
                break;
            }
            case 6: {
                clip.setShuffleEnabled(value <= 61);
                break;
            }
            case 7: {
                clip.changeAccent(value, shiftPressed);
                break;
            }
        }
    }

    @Override
    public void updateDisplay1(ITextDisplay display) {
        IClip clip = this.getMidiClip();
        if (!clip.doesExist()) {
            display.notify(PLEASE_SELECT_A_CLIP_PUSH1);
            return;
        }
        display.setCell(0, 0, "PlayStrt").setCell(1, 0, this.formatMeasures(clip.getPlayStart(), 1));
        display.setCell(0, 1, "Play End").setCell(1, 1, this.formatMeasures(clip.getPlayEnd(), 1));
        display.setCell(0, 2, "LoopStrt").setCell(1, 2, this.formatMeasures(clip.getLoopStart(), 1));
        display.setCell(0, 3, "LopLngth").setCell(1, 3, this.formatMeasures(clip.getLoopLength(), 0));
        display.setCell(0, 4, "Loop").setCell(1, 4, clip.isLoopEnabled() ? "On" : "Off");
        display.setCell(0, 6, "Shuffle").setCell(1, 6, clip.isShuffleEnabled() ? "On" : "Off");
        display.setCell(0, 7, "Accent").setCell(1, 7, clip.getFormattedAccent());
        this.drawRow4(display);
    }

    @Override
    public void updateDisplay2(IGraphicDisplay display) {
        INoteClip noteClip;
        IClip clip = this.getMidiClip();
        if (!clip.doesExist()) {
            display.addEmptyElement();
            display.notify(PLEASE_SELECT_A_CLIP_PUSH2);
            return;
        }
        if (this.displayMidiNotes) {
            display.setMidiClipElement((INoteClip)clip, this.transport.getQuartersPerMeasure(), this.activeNotePosition);
            return;
        }
        ITrackBank tb = this.model.getCurrentTrackBank();
        ITrack t0 = (ITrack)tb.getItem(0);
        ITrack t1 = (ITrack)tb.getItem(1);
        ITrack t2 = (ITrack)tb.getItem(2);
        ITrack t3 = (ITrack)tb.getItem(3);
        ITrack t4 = (ITrack)tb.getItem(4);
        ITrack t5 = (ITrack)tb.getItem(5);
        ITrack t6 = (ITrack)tb.getItem(6);
        ITrack t7 = (ITrack)tb.getItem(7);
        boolean canPin = this.model.getHost().supports(Capability.HAS_PINNING);
        boolean isPinned = canPin && clip instanceof INoteClip && (noteClip = (INoteClip)clip).isPinned();
        display.addParameterElement(canPin ? "Pin clip" : "", isPinned, t0.getName(), this.updateType(t0), t0.getColor(), t0.isSelected(), "Play Start", -1, this.formatMeasures(clip.getPlayStart(), 1), this.isKnobTouched(0), -1);
        display.addParameterElement("", false, t1.getName(), this.updateType(t1), t1.getColor(), t1.isSelected(), "Play End", -1, this.formatMeasures(clip.getPlayEnd(), 1), this.isKnobTouched(1), -1);
        display.addParameterElement("", false, t2.getName(), this.updateType(t2), t2.getColor(), t2.isSelected(), "Loop Start", -1, this.formatMeasures(clip.getLoopStart(), 1), this.isKnobTouched(2), -1);
        display.addParameterElement("", false, t3.getName(), this.updateType(t3), t3.getColor(), t3.isSelected(), "Loop Lngth", -1, this.formatMeasures(clip.getLoopLength(), 0), this.isKnobTouched(3), -1);
        display.addParameterElement("", false, t4.getName(), this.updateType(t4), t4.getColor(), t4.isSelected(), "Loop", -1, clip.isLoopEnabled() ? "On" : "Off", this.isKnobTouched(4), -1);
        display.addParameterElement("", false, t5.getName(), this.updateType(t5), t5.getColor(), t5.isSelected(), "", -1, "", false, -1);
        display.addParameterElement("", false, t6.getName(), this.updateType(t6), t6.getColor(), t6.isSelected(), "Shuffle", -1, clip.isShuffleEnabled() ? "On" : "Off", this.isKnobTouched(6), -1);
        display.addParameterElement("Select color", false, t7.getName(), this.updateType(t7), t7.getColor(), t7.isSelected(), "Accent", -1, clip.getFormattedAccent(), this.isKnobTouched(7), -1);
    }

    @Override
    public void onSecondRow(int index, ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        if (this.displayMidiNotes) {
            this.displayMidiNotes = false;
            return;
        }
        if (index == 0) {
            IClip clip = this.getMidiClip();
            if (clip instanceof INoteClip) {
                INoteClip noteClip = (INoteClip)clip;
                noteClip.togglePinned();
            }
            return;
        }
        if (index == 7) {
            ViewManager viewManager = ((PushControlSurface)this.surface).getViewManager();
            ((ColorView)viewManager.get(Views.COLOR)).setMode(ColorSelectMode.MODE_CLIP);
            viewManager.setActive(Views.COLOR);
        }
    }

    @Override
    public int getButtonColor(ButtonID buttonID) {
        int index = this.isButtonRow(1, buttonID);
        if (index >= 0) {
            if (index == 0) {
                INoteClip noteClip;
                if (!this.model.getHost().supports(Capability.HAS_PINNING)) {
                    return 0;
                }
                IClip clip = this.getMidiClip();
                boolean isPinned = clip instanceof INoteClip && (noteClip = (INoteClip)clip).isPinned();
                return isPinned ? 22 : 3;
            }
            if (index == 7) {
                return this.displayMidiNotes ? 0 : 3;
            }
            return 0;
        }
        return super.getButtonColor(buttonID);
    }

    public void togglePianoRoll() {
        this.displayMidiNotes = !this.displayMidiNotes;
    }

    private String formatMeasures(double time, int startOffset) {
        return StringUtils.formatMeasures(this.transport.getQuartersPerMeasure(), time, startOffset, false);
    }

    @Override
    public void encoderTurn(int value) {
        IClip clip = this.getMidiClip();
        if (clip instanceof INoteClip) {
            INoteClip noteClip = (INoteClip)clip;
            this.activeNotePosition = this.model.getValueChanger().isIncrease(value) ? noteClip.getNextNote(this.activeNotePosition, true) : noteClip.getPreviousNote(this.activeNotePosition, true);
        }
    }

    @Override
    public void encoderLeft(ButtonEvent event) {
        ViewManager viewManager = ((PushControlSurface)this.surface).getViewManager();
        Object f = viewManager.getActive();
        if (f instanceof AbstractSequencerView) {
            AbstractSequencerView sequencerView = (AbstractSequencerView)f;
            sequencerView.onLeft(event);
            this.activeNotePosition = null;
        }
    }

    @Override
    public void encoderRight(ButtonEvent event) {
        ViewManager viewManager = ((PushControlSurface)this.surface).getViewManager();
        Object f = viewManager.getActive();
        if (f instanceof AbstractSequencerView) {
            AbstractSequencerView sequencerView = (AbstractSequencerView)f;
            sequencerView.onRight(event);
            this.activeNotePosition = null;
        }
    }

    @Override
    public void encoderPress(ButtonEvent event) {
        Object f;
        if (event != ButtonEvent.UP) {
            return;
        }
        if (this.activeNotePosition != null && (f = ((PushControlSurface)this.surface).getViewManager().getActive()) instanceof AbstractSequencerView) {
            AbstractSequencerView sequencerView = (AbstractSequencerView)f;
            sequencerView.editNote(this.activeNotePosition, false);
        }
    }

    @Override
    public void arrowCenter(ButtonEvent event) {
    }

    private IClip getMidiClip() {
        if (this.displayMidiNotes) {
            IView activeView = (IView)((PushControlSurface)this.surface).getViewManager().getActive();
            if (activeView instanceof AbstractSequencerView) {
                AbstractSequencerView sequencerView = (AbstractSequencerView)activeView;
                return sequencerView.getClip();
            }
            return this.model.getNoteClip(8, 128);
        }
        return this.model.getCursorClip();
    }
}

