/*
 * Decompiled with CFR 0.152.
 */
package purejavahidapi.shared;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import purejavahidapi.DeviceRemovalListener;
import purejavahidapi.HidDevice;
import purejavahidapi.HidDeviceInfo;

public abstract class Backend {
    private HashMap<String, HidDevice> m_OpenDevices = new HashMap();

    public abstract void init();

    public abstract void cleanup();

    public abstract List<HidDeviceInfo> enumerateDevices();

    public abstract HidDevice openDevice(HidDeviceInfo var1) throws IOException;

    public void removeDevice(String deviceId) {
        this.m_OpenDevices.remove(deviceId);
    }

    public void addDevice(String deviceId, HidDevice device) {
        this.m_OpenDevices.put(deviceId, device);
    }

    public HidDevice getDevice(String deviceId) {
        return this.m_OpenDevices.get(deviceId);
    }

    public void deviceRemoved(String deviceId) {
        HidDevice device = this.getDevice(deviceId);
        if (device != null) {
            DeviceRemovalListener listener = device.getDeviceRemovalListener();
            device.close();
            if (listener != null) {
                listener.onDeviceRemoval(device);
            }
        }
    }
}

