/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.device.column;

import de.mossgrabers.framework.daw.data.IBrowserColumnItem;
import de.mossgrabers.framework.utils.StringUtils;
import de.mossgrabers.reaper.communication.Processor;
import de.mossgrabers.reaper.framework.daw.data.ItemImpl;

public abstract class BaseColumnItem
extends ItemImpl
implements IBrowserColumnItem {
    protected int hits = 0;

    protected BaseColumnItem(int index) {
        super(null, index);
    }

    @Override
    public boolean doesExist() {
        return true;
    }

    @Override
    public String getName(int limit) {
        return StringUtils.optimizeName(this.getName(), limit);
    }

    @Override
    public String getName() {
        int idx = this.getIndex();
        if (this.name == null || idx != this.position) {
            this.updateCache(idx);
        }
        return this.name;
    }

    @Override
    public int getHitCount() {
        int idx = this.getIndex();
        if (idx != this.position) {
            this.updateCache(idx);
        }
        return this.hits;
    }

    @Override
    protected Processor getProcessor() {
        return null;
    }

    protected abstract String getCachedName();

    protected abstract int getCachedHitCount();

    private void updateCache(int idx) {
        this.position = idx;
        this.name = this.getCachedName();
        this.hits = this.getCachedHitCount();
    }

    public String toString() {
        return this.getCachedName() + " (" + this.getCachedHitCount() + ")";
    }
}

