/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.daw.data.bank;

import de.mossgrabers.framework.daw.data.IDevice;
import de.mossgrabers.framework.daw.data.bank.AbstractBank;
import de.mossgrabers.framework.daw.data.bank.IParameterBank;
import de.mossgrabers.framework.daw.data.bank.IParameterPageBank;
import de.mossgrabers.framework.observer.IItemSelectionObserver;
import de.mossgrabers.reaper.framework.daw.data.bank.ParameterBankImpl;
import de.mossgrabers.reaper.framework.daw.data.parameter.map.ParameterMap;
import de.mossgrabers.reaper.framework.daw.data.parameter.map.ParameterMapPage;
import de.mossgrabers.reaper.framework.device.DeviceManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class ParameterPageBankImpl
extends AbstractBank<String>
implements IParameterPageBank {
    private final IParameterBank parameterBank;
    private final IDevice device;
    private final List<String> cachedPageNames = new ArrayList<String>();
    private int cachedPageCount = -1;

    public ParameterPageBankImpl(int numParameterPages, IParameterBank parameterBank, IDevice device) {
        super(null, numParameterPages);
        this.parameterBank = parameterBank;
        this.device = device;
        if (this.device != null) {
            this.device.addNameObserver(name -> this.updatePageCache());
        }
        this.clearPageCache();
    }

    @Override
    public void enableObservers(boolean enable) {
    }

    @Override
    public int getItemCount() {
        if (this.cachedPageCount >= 0) {
            return this.cachedPageCount;
        }
        int itemCount = this.parameterBank.getItemCount();
        int ps = this.parameterBank.getPageSize();
        return itemCount / ps + (itemCount % ps > 0 ? 1 : 0);
    }

    @Override
    public boolean canScrollBackwards() {
        return this.canScrollPageBackwards();
    }

    @Override
    public boolean canScrollForwards() {
        return this.getSelectedItemPosition() < this.parameterBank.getItemCount();
    }

    @Override
    public boolean canScrollPageBackwards() {
        return this.parameterBank.getScrollPosition() > 0;
    }

    @Override
    public boolean canScrollPageForwards() {
        return this.parameterBank.getScrollPosition() + this.parameterBank.getPageSize() < this.parameterBank.getItemCount();
    }

    @Override
    public void scrollBackwards() {
        this.parameterBank.scrollBackwards();
        ((ParameterBankImpl)this.parameterBank).firePageObserver();
    }

    @Override
    public void scrollForwards() {
        this.parameterBank.scrollForwards();
        ((ParameterBankImpl)this.parameterBank).firePageObserver();
    }

    @Override
    public void scrollTo(int position) {
        this.parameterBank.scrollTo(position * this.parameterBank.getPageSize());
        ((ParameterBankImpl)this.parameterBank).firePageObserver();
    }

    @Override
    public void scrollTo(int position, boolean adjustPage) {
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    public String getItem(int index) {
        int pos = this.getScrollPosition() + index;
        return pos < this.cachedPageNames.size() ? this.cachedPageNames.get(pos) : "";
    }

    @Override
    public int getSelectedItemPosition() {
        int ps = this.parameterBank.getPageSize();
        int scrollPosition = this.parameterBank.getScrollPosition();
        return scrollPosition / ps + (scrollPosition % ps > 0 ? 1 : 0);
    }

    @Override
    public int getSelectedItemIndex() {
        return this.getSelectedItemPosition() % this.pageSize;
    }

    @Override
    public Optional<String> getSelectedItem() {
        return Optional.of(this.getItem(this.getSelectedItemIndex()));
    }

    @Override
    public List<String> getSelectedItems() {
        Optional<String> selectedItem = this.getSelectedItem();
        return Collections.singletonList(selectedItem.isPresent() ? selectedItem.get() : "");
    }

    @Override
    public void selectPage(int index) {
        this.scrollTo(this.getScrollPosition() + index);
    }

    @Override
    public void addSelectionObserver(IItemSelectionObserver observer) {
    }

    @Override
    public int getScrollPosition() {
        int scrollPosition = this.getSelectedItemPosition();
        return scrollPosition / this.pageSize * this.pageSize;
    }

    @Override
    public void selectNextItem() {
    }

    @Override
    public void selectPreviousItem() {
    }

    @Override
    public void selectPreviousPage() {
        this.parameterBank.selectPreviousPage();
        this.updatePageCache();
    }

    @Override
    public void selectNextPage() {
        this.parameterBank.selectNextPage();
        this.updatePageCache();
    }

    @Override
    public void selectItemAtPosition(int position) {
    }

    @Override
    public int getPositionOfLastItem() {
        return Math.min(this.getScrollPosition() + this.pageSize, this.getItemCount()) - 1;
    }

    public void updatePageCache() {
        this.clearPageCache();
        ParameterMap parameterMap = null;
        if (this.device != null) {
            String deviceName = this.device.getName();
            parameterMap = DeviceManager.get().getParameterMaps().get(deviceName.toLowerCase());
        }
        if (parameterMap == null) {
            int itemCount = this.parameterBank.getItemCount();
            int ps = this.parameterBank.getPageSize();
            this.cachedPageCount = itemCount / ps + (itemCount % ps > 0 ? 1 : 0);
            for (int i = 0; i < this.cachedPageCount; ++i) {
                this.cachedPageNames.add("Page " + (i + 1));
            }
        } else {
            List<ParameterMapPage> pages = parameterMap.getPages();
            this.cachedPageCount = pages.size();
            for (ParameterMapPage page : pages) {
                this.cachedPageNames.add(page.getName());
            }
        }
        ((ParameterBankImpl)this.parameterBank).firePageObserver();
    }

    private void clearPageCache() {
        this.cachedPageCount = -1;
        this.cachedPageNames.clear();
    }
}

