/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.controller;

import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.ContinuousID;
import de.mossgrabers.framework.controller.OutputID;
import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.controller.display.IDisplay;
import de.mossgrabers.framework.controller.display.IGraphicDisplay;
import de.mossgrabers.framework.controller.display.ITextDisplay;
import de.mossgrabers.framework.controller.grid.ILightGuide;
import de.mossgrabers.framework.controller.grid.IPadGrid;
import de.mossgrabers.framework.controller.hardware.BindType;
import de.mossgrabers.framework.controller.hardware.IHwAbsoluteKnob;
import de.mossgrabers.framework.controller.hardware.IHwButton;
import de.mossgrabers.framework.controller.hardware.IHwContinuousControl;
import de.mossgrabers.framework.controller.hardware.IHwFader;
import de.mossgrabers.framework.controller.hardware.IHwLight;
import de.mossgrabers.framework.controller.hardware.IHwPianoKeyboard;
import de.mossgrabers.framework.controller.hardware.IHwRelativeKnob;
import de.mossgrabers.framework.controller.hardware.IHwSurfaceFactory;
import de.mossgrabers.framework.controller.valuechanger.ISensitivityCallback;
import de.mossgrabers.framework.controller.valuechanger.RelativeEncoding;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.midi.IMidiInput;
import de.mossgrabers.framework.daw.midi.IMidiOutput;
import de.mossgrabers.framework.featuregroup.ModeManager;
import de.mossgrabers.framework.featuregroup.ViewManager;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import java.util.function.IntSupplier;
import java.util.function.Supplier;

public interface IControlSurface<C extends Configuration> {
    public int getSurfaceID();

    public ViewManager getViewManager();

    public void recallPreferredView(ITrack var1);

    public ModeManager getModeManager();

    public C getConfiguration();

    public ITextDisplay getTextDisplay();

    public IDisplay getDisplay();

    public ITextDisplay getTextDisplay(int var1);

    public void addTextDisplay(ITextDisplay var1);

    public IGraphicDisplay getGraphicsDisplay();

    public IGraphicDisplay getGraphicsDisplay(int var1);

    public void addGraphicsDisplay(IGraphicDisplay var1);

    public IPadGrid getPadGrid();

    public ILightGuide getLightGuide();

    public IMidiOutput getMidiOutput();

    public IMidiInput getMidiInput();

    public void setKeyTranslationTable(int[] var1);

    public int[] getKeyTranslationTable();

    public void setVelocityTranslationTable(int[] var1);

    public boolean isSelectPressed();

    public boolean isShiftPressed();

    public boolean isDeletePressed();

    public boolean isSoloPressed();

    public boolean isMutePressed();

    public boolean isPressed(ButtonID var1);

    public boolean isLongPressed(ButtonID var1);

    public void setTriggerConsumed(ButtonID var1);

    public boolean isTriggerConsumed(ButtonID var1);

    public void setTrigger(int var1, int var2);

    public void setTrigger(int var1, int var2, int var3);

    public void setTrigger(BindType var1, int var2, int var3, int var4);

    public void addPianoKeyboard(int var1, IMidiInput var2, boolean var3);

    public IHwPianoKeyboard getPianoKeyboard();

    public IHwButton createButton(ButtonID var1, String var2);

    public Map<ButtonID, IHwButton> getButtons();

    public IHwButton getButton(ButtonID var1);

    public IHwLight getLight(OutputID var1);

    public Collection<IHwLight> getLights();

    public IHwLight createLight(OutputID var1, Supplier<ColorEx> var2, Consumer<ColorEx> var3);

    public IHwLight createLight(OutputID var1, IntSupplier var2, IntConsumer var3, IntFunction<ColorEx> var4, IHwButton var5);

    public IHwFader createFader(ContinuousID var1, String var2, boolean var3);

    public IHwAbsoluteKnob createAbsoluteKnob(ContinuousID var1, String var2);

    public IHwRelativeKnob createRelativeKnob(ContinuousID var1, String var2);

    public IHwRelativeKnob createRelativeKnob(ContinuousID var1, String var2, RelativeEncoding var3);

    public IHwContinuousControl getContinuous(ContinuousID var1);

    public List<IHwRelativeKnob> getRelativeKnobs();

    public boolean isKnobSensitivitySlow();

    public void setKnobSensitivityIsSlow(boolean var1);

    public void turnOffTriggers();

    public void scheduleTask(Runnable var1, long var2);

    public void sendMidiEvent(int var1, int var2, int var3);

    public void flush();

    public void forceFlush();

    public void flushButtonLEDs();

    public void clearCache();

    public void shutdown();

    public void println(String var1);

    public void errorln(String var1);

    public IHwSurfaceFactory getSurfaceFactory();

    public void unbindAllInputControls();

    public void rebindAllInputControls();

    public void unbindGrid();

    public void rebindGrid();

    public void addKnobSensitivityObserver(ISensitivityCallback var1);

    public void consumePads();
}

