/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.command.trigger.track;

import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import de.mossgrabers.framework.utils.ButtonEvent;

public class ToggleTrackBanksCommand<S extends IControlSurface<C>, C extends Configuration>
extends AbstractTriggerCommand<S, C> {
    public ToggleTrackBanksCommand(IModel model, S surface) {
        super(model, surface);
    }

    @Override
    public void executeNormal(ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        this.model.toggleCurrentTrackBank();
        ITrackBank currentTrackBank = this.model.getCurrentTrackBank();
        this.surface.getDisplay().notify(this.model.isEffectTrackBankActive() ? "Effect Tracks" : "Audio & Instrument Tracks");
        if (currentTrackBank.getSelectedItem().isEmpty()) {
            ((ITrack)currentTrackBank.getItem(0)).select();
        }
    }
}

