/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.oxi.one.mode;

import de.mossgrabers.controller.oxi.one.OxiOneConfiguration;
import de.mossgrabers.controller.oxi.one.controller.OxiOneControlSurface;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.ContinuousID;
import de.mossgrabers.framework.controller.display.IGraphicDisplay;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.ITransport;
import de.mossgrabers.framework.daw.data.IItem;
import de.mossgrabers.framework.featuregroup.AbstractParameterMode;
import de.mossgrabers.framework.graphics.canvas.component.simple.TitleValueMenuComponent;
import de.mossgrabers.framework.parameter.IParameter;
import de.mossgrabers.framework.parameterprovider.special.CombinedParameterProvider;
import de.mossgrabers.framework.parameterprovider.special.EmptyParameterProvider;
import de.mossgrabers.framework.parameterprovider.special.FixedParameterProvider;
import de.mossgrabers.framework.parameterprovider.special.FourKnobProvider;

public class OxiOneAutomationMode
extends AbstractParameterMode<OxiOneControlSurface, OxiOneConfiguration, IItem> {
    private static final String[] MENU = new String[]{"Mode", "", "", ""};
    private static final String[] SHIFTED_MENU = new String[]{"", "", "", ""};
    private final int selectedParameter = 0;
    private final IParameter[] parameters = new IParameter[4];
    private final ITransport transport = this.model.getTransport();

    public OxiOneAutomationMode(OxiOneControlSurface surface, IModel model) {
        super("Automation", surface, model, false);
        this.setControls(ContinuousID.createSequentialList(ContinuousID.KNOB1, 4));
        this.parameters[0] = this.transport.getAutomationModeParameter();
        this.setParameterProvider(new FourKnobProvider(surface, new CombinedParameterProvider(new FixedParameterProvider(this.parameters[0]), new EmptyParameterProvider(3)), ButtonID.SHIFT));
    }

    @Override
    public void updateDisplay() {
        IGraphicDisplay display = ((OxiOneControlSurface)this.surface).getGraphicsDisplay();
        String desc = this.parameters[this.selectedParameter].getName();
        String label = this.parameters[this.selectedParameter].getDisplayedValue();
        int value = this.selectedParameter > 0 && this.selectedParameter < 3 ? this.parameters[this.selectedParameter].getValue() : 0;
        display.addElement(new TitleValueMenuComponent(desc, label, ((OxiOneControlSurface)this.surface).isShiftPressed() ? SHIFTED_MENU : MENU, value, -1, -1, false));
        display.send();
    }
}

