/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.osc.module;

import de.mossgrabers.controller.osc.OSCConfiguration;
import de.mossgrabers.controller.osc.exception.IllegalParameterException;
import de.mossgrabers.controller.osc.exception.MissingCommandException;
import de.mossgrabers.controller.osc.exception.UnknownCommandException;
import de.mossgrabers.controller.osc.module.AbstractModule;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.controller.color.ColorManager;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.constants.Resolution;
import de.mossgrabers.framework.daw.data.ICursorTrack;
import de.mossgrabers.framework.daw.midi.IMidiInput;
import de.mossgrabers.framework.daw.midi.INoteInput;
import de.mossgrabers.framework.daw.midi.INoteRepeat;
import de.mossgrabers.framework.featuregroup.AbstractView;
import de.mossgrabers.framework.osc.IOpenSoundControlWriter;
import de.mossgrabers.framework.scale.Scales;
import de.mossgrabers.framework.utils.KeyManager;
import java.util.LinkedList;

public class MidiModule
extends AbstractModule {
    private final KeyManager keyManager;
    private final IControlSurface<OSCConfiguration> surface;

    public MidiModule(IHost host, IModel model, IControlSurface<OSCConfiguration> surface, IOpenSoundControlWriter writer, KeyManager keyManager) {
        super(host, model, writer);
        this.surface = surface;
        this.keyManager = keyManager;
        this.updateNoteMatrix(model.getScales());
    }

    @Override
    public String[] getSupportedCommands() {
        return new String[]{"vkb_midi"};
    }

    @Override
    public void execute(String command, LinkedList<String> path, Object value) throws IllegalParameterException, UnknownCommandException, MissingCommandException {
        if (!"vkb_midi".equals(command)) {
            throw new UnknownCommandException(command);
        }
        this.parseMidi(path, value);
    }

    @Override
    public void flush(boolean dump) {
        String noteAddress = "/vkb_midi/note/";
        for (int i = 0; i < 127; ++i) {
            double[] color = this.getNoteColor(i).toDoubleRGB();
            this.writer.sendOSCColor("/vkb_midi/note/" + i + "/color", color[0], color[1], color[2], dump);
        }
        INoteInput noteInput = this.surface.getMidiInput().getDefaultNoteInput();
        if (noteInput == null) {
            return;
        }
        INoteRepeat noteRepeat = noteInput.getNoteRepeat();
        String noteRepeatAddress = "/vkb_midi/noterepeat/";
        this.writer.sendOSC("/vkb_midi/noterepeat/isActive", noteRepeat.isActive(), dump);
        this.writer.sendOSC("/vkb_midi/noterepeat/period", Resolution.getNameAt(Resolution.getMatch(noteRepeat.getPeriod())), dump);
        this.writer.sendOSC("/vkb_midi/noterepeat/length", Resolution.getNameAt(Resolution.getMatch(noteRepeat.getNoteLength())), dump);
    }

    private void parseMidi(LinkedList<String> path, Object value) throws IllegalParameterException, UnknownCommandException, MissingCommandException {
        int midiChannel;
        String command;
        OSCConfiguration conf = this.surface.getConfiguration();
        switch (command = MidiModule.getSubCommand(path)) {
            case "velocity": {
                int numValue = MidiModule.toInteger(value);
                conf.setAccentEnabled(numValue > 0);
                if (numValue > 0) {
                    conf.setFixedAccentValue(numValue);
                }
                return;
            }
            case "noterepeat": {
                this.parseNoteRepeat(path, value);
                return;
            }
        }
        try {
            midiChannel = Math.min(Math.max(0, Integer.parseInt(command) - 1), 15);
        }
        catch (NumberFormatException ex) {
            throw new UnknownCommandException(command);
        }
        String subCommand = MidiModule.getSubCommand(path);
        IMidiInput input = this.surface.getMidiInput();
        Scales scales = this.model.getScales();
        block16 : switch (subCommand) {
            case "note": {
                String n;
                if (path.isEmpty()) {
                    Object[] array = (Object[])value;
                    int note = ((Number)array[0]).intValue();
                    int velocity = ((Number)array[1]).intValue();
                    this.sendNote(conf, midiChannel, input, note, velocity);
                    return;
                }
                switch (n = MidiModule.getSubCommand(path)) {
                    case "+": {
                        if (!MidiModule.isTrigger(value)) break block16;
                        scales.incOctave();
                        this.updateNoteMatrix(scales);
                        break;
                    }
                    case "-": {
                        if (!MidiModule.isTrigger(value)) break block16;
                        scales.decOctave();
                        this.updateNoteMatrix(scales);
                        break;
                    }
                    default: {
                        this.sendNote(conf, midiChannel, input, Integer.parseInt(n), MidiModule.toInteger(value));
                        break;
                    }
                }
                break;
            }
            case "drum": {
                String n2;
                switch (n2 = MidiModule.getSubCommand(path)) {
                    case "+": {
                        if (!MidiModule.isTrigger(value)) break block16;
                        scales.incDrumOctave();
                        this.adjustDrumDevice();
                        break;
                    }
                    case "-": {
                        if (!MidiModule.isTrigger(value)) break block16;
                        scales.decDrumOctave();
                        this.adjustDrumDevice();
                        break;
                    }
                    default: {
                        int data0;
                        int note = Integer.parseInt(n2);
                        int numValue = MidiModule.toInteger(value);
                        if (numValue > 0) {
                            int n = numValue = conf.isAccentActive() ? conf.getFixedAccentValue() : numValue;
                        }
                        if ((data0 = this.model.getScales().getDrumMatrix()[note]) < 0) break block16;
                        input.sendRawMidiEvent(144 + midiChannel, data0, numValue);
                        break;
                    }
                }
                break;
            }
            case "cc": {
                if (path.isEmpty()) {
                    this.host.println("Missing MIDI CC value.");
                    return;
                }
                int cc = Integer.parseInt(path.removeFirst());
                input.sendRawMidiEvent(176 + midiChannel, cc, MidiModule.toInteger(value));
                break;
            }
            case "aftertouch": {
                int numValue = MidiModule.toInteger(value);
                if (path.isEmpty()) {
                    input.sendRawMidiEvent(208 + midiChannel, 0, numValue);
                    return;
                }
                int note = Integer.parseInt(path.removeFirst());
                input.sendRawMidiEvent(160 + midiChannel, this.surface.getKeyTranslationTable()[note], numValue);
                break;
            }
            case "pitchbend": {
                input.sendRawMidiEvent(224 + midiChannel, 0, MidiModule.toInteger(value));
                break;
            }
            default: {
                throw new UnknownCommandException(command);
            }
        }
    }

    private void adjustDrumDevice() {
        Scales scales = this.model.getScales();
        this.model.getDrumDevice().getDrumPadBank().scrollTo(scales.getDrumOffset(), false);
        this.host.showNotification(scales.getDrumRangeText());
    }

    private void updateNoteMatrix(Scales scales) {
        int[] matrix = scales.getNoteMatrix();
        this.keyManager.setNoteMatrix(matrix);
        this.surface.setKeyTranslationTable(matrix);
        this.surface.getDisplay().notify(scales.getRangeText());
    }

    private void sendNote(OSCConfiguration conf, int midiChannel, IMidiInput input, int note, int numValue) {
        int value = numValue > 0 && conf.isAccentActive() ? conf.getFixedAccentValue() : numValue;
        int[] keyTranslationMatrix = this.surface.getKeyTranslationTable();
        int data0 = keyTranslationMatrix[note];
        if (data0 >= 0) {
            input.sendRawMidiEvent(144 + midiChannel, data0, value);
        }
        for (int i = 0; i < 128; ++i) {
            if (keyTranslationMatrix[note] != keyTranslationMatrix[i]) continue;
            this.keyManager.setKeyPressed(i, value);
        }
    }

    private void parseNoteRepeat(LinkedList<String> path, Object value) throws MissingCommandException, UnknownCommandException, IllegalParameterException {
        String subCommand;
        INoteInput noteInput = this.surface.getMidiInput().getDefaultNoteInput();
        if (noteInput == null) {
            return;
        }
        INoteRepeat noteRepeat = noteInput.getNoteRepeat();
        switch (subCommand = MidiModule.getSubCommand(path)) {
            case "isActive": {
                noteRepeat.setActive(MidiModule.toInteger(value) > 0);
                break;
            }
            case "period": {
                if (value == null) {
                    throw new IllegalParameterException("Value must not be empty.");
                }
                Resolution period = Resolution.getByName(value.toString());
                if (period == null) {
                    throw new IllegalParameterException("Value must be one of {1/4, 1/4t, 1/8, 1/8t, 1/16, 1/16t, 1/32, 1/32t}.");
                }
                noteRepeat.setPeriod(period.getValue());
                break;
            }
            case "length": {
                if (value == null) {
                    throw new IllegalParameterException("Value must not be empty.");
                }
                Resolution length = Resolution.getByName(value.toString());
                if (length == null) {
                    throw new IllegalParameterException("Value must be one of {1/4, 1/4t, 1/8, 1/8t, 1/16, 1/16t, 1/32, 1/32t}.");
                }
                noteRepeat.setNoteLength(length.getValue());
                break;
            }
            default: {
                throw new UnknownCommandException(subCommand);
            }
        }
    }

    private ColorEx getNoteColor(int note) {
        ColorManager colorManager = this.model.getColorManager();
        boolean isKeyboardEnabled = this.model.canSelectedTrackHoldNotes();
        if (!isKeyboardEnabled) {
            return ColorEx.BLACK;
        }
        if (this.keyManager.isKeyPressed(note)) {
            return this.model.hasRecordingState() ? ColorEx.RED : ColorEx.GREEN;
        }
        ICursorTrack cursorTrack = this.model.getCursorTrack();
        String colorID = AbstractView.replaceOctaveColorWithTrackColor(cursorTrack, this.keyManager.getColor(note));
        int colorIndex = colorManager.getColorIndex(colorID);
        return colorManager.getColor(colorIndex, null);
    }
}

