/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.slmkiii.controller;

import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.controller.display.AbstractTextDisplay;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.midi.IMidiOutput;
import de.mossgrabers.framework.utils.StringUtils;

public class SLMkIIIDisplay
extends AbstractTextDisplay {
    private static final String MKIII_SYSEX_HEADER = "F0 00 20 29 02 0A 01 ";
    private static final String MKIII_SYSEX_LAYOUT_COMMAND = "F0 00 20 29 02 0A 01 01 %02d F7";
    private static final String MKIII_SYSEX_PROPERTY_COMMAND = "F0 00 20 29 02 0A 01 02 %02d %02d %02d %s F7";
    private static final String MKIII_SYSEX_LED_COMMAND = "F0 00 20 29 02 0A 01 03 %02X 01 %02X %02X %02X F7";
    private static final String MKIII_SYSEX_NOTIFICATION_COMMAND = "F0 00 20 29 02 0A 01 04 %s F7";
    public static final Integer SCREEN_LAYOUT_EMPTY = 0;
    public static final Integer SCREEN_LAYOUT_KNOB = 1;
    public static final Integer SCREEN_LAYOUT_BOX = 2;
    private static final Integer PROPERTY_TEXT = 1;
    private static final Integer PROPERTY_COLOR = 2;
    private static final Integer PROPERTY_VALUE = 3;
    private final int[][] displayColorCache = new int[9][4];
    private final int[][] displayValueCache = new int[9][4];
    private int selectedLayout = -1;

    public SLMkIIIDisplay(IHost host, IMidiOutput output) {
        super(host, output, 4, 9, 81);
        this.clearDisplayCache();
    }

    @Override
    public void writeLine(int row, String text, String previousText) {
        for (int i = 0; i < this.noOfCells; ++i) {
            int pos = 9 * i;
            String cellText = text.substring(pos, pos + 9).trim();
            this.setPropertyText(i, row, cellText);
        }
    }

    public void setDisplayLayout(Integer layout) {
        if (this.selectedLayout == layout) {
            return;
        }
        this.selectedLayout = layout;
        this.output.sendSysex(String.format(MKIII_SYSEX_LAYOUT_COMMAND, layout));
        this.clearDisplayCache();
        this.forceFlush();
    }

    public void hideAllElements() {
        for (int i = 0; i < 8; ++i) {
            this.setPropertyColor(i, 0, 0);
            this.setPropertyColor(i, 1, 0);
        }
    }

    public void setFaderLEDColor(int led, ColorEx color) {
        int[] rgb = color.toIntRGB127();
        this.output.sendSysex(String.format(MKIII_SYSEX_LED_COMMAND, led, rgb[0], rgb[1], rgb[2]));
    }

    public void setPropertyColor(int hPosition, int vPosition, int color) {
        if (this.displayColorCache[hPosition][vPosition] == color) {
            return;
        }
        this.displayColorCache[hPosition][vPosition] = color;
        this.setProperty(PROPERTY_COLOR, hPosition, vPosition, StringUtils.toHexStr(color));
    }

    private void setPropertyText(int hPosition, int vPosition, String text) {
        String ascii = StringUtils.fixASCII(text);
        if (ascii.length() > 9) {
            ascii = ascii.substring(0, 9);
        }
        String value = StringUtils.toHexStr(ascii.getBytes()) + "00";
        this.setProperty(PROPERTY_TEXT, hPosition, vPosition, value);
    }

    public void setPropertyValue(int hPosition, int vPosition, int value) {
        if (this.displayValueCache[hPosition][vPosition] == value) {
            return;
        }
        this.displayValueCache[hPosition][vPosition] = value;
        this.setProperty(PROPERTY_VALUE, hPosition, vPosition, StringUtils.toHexStr(value));
    }

    private void setProperty(Integer property, int hPosition, int vPosition, String values) {
        String msg = String.format(MKIII_SYSEX_PROPERTY_COMMAND, hPosition, property, vPosition, values);
        this.output.sendSysex(msg);
    }

    @Override
    protected void notifyOnDisplay(String message) {
        String text2;
        String text1;
        String ascii = StringUtils.fixASCII(message);
        if (ascii.length() > 18) {
            text1 = ascii.substring(0, 18);
            text2 = ascii.substring(18, message.length());
        } else {
            text1 = ascii;
            text2 = "";
        }
        String content = StringUtils.asciiToHex(text1) + "00 " + StringUtils.asciiToHex(text2) + "00";
        String msg = String.format(MKIII_SYSEX_NOTIFICATION_COMMAND, content);
        this.output.sendSysex(msg);
    }

    private void clearDisplayCache() {
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 4; ++j) {
                this.displayColorCache[i][j] = -1;
                this.displayValueCache[i][j] = -1;
            }
        }
    }

    @Override
    public void shutdown() {
        this.hideAllElements();
        this.setPropertyColor(8, 0, 0);
        this.setPropertyColor(8, 1, 0);
        for (int i = 0; i < 9; ++i) {
            this.setPropertyColor(i, 2, 0);
            this.setPropertyValue(i, 1, 0);
        }
        this.clear().setCell(1, 2, "Please").setCell(1, 3, "start").setCell(1, 4, this.host.getName() + "...").allDone();
        this.flush();
    }
}

