/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.sl.view;

import de.mossgrabers.controller.novation.sl.SLConfiguration;
import de.mossgrabers.controller.novation.sl.command.trigger.ButtonRowSelectCommand;
import de.mossgrabers.controller.novation.sl.command.trigger.P2ButtonCommand;
import de.mossgrabers.controller.novation.sl.controller.SLControlSurface;
import de.mossgrabers.controller.novation.sl.mode.device.DevicePresetsMode;
import de.mossgrabers.controller.novation.sl.mode.device.SLParameterMode;
import de.mossgrabers.controller.novation.sl.view.SLView;
import de.mossgrabers.controller.novation.sl.view.TransportControl;
import de.mossgrabers.framework.command.trigger.clip.NewCommand;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.ITransport;
import de.mossgrabers.framework.daw.data.ICursorDevice;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import de.mossgrabers.framework.featuregroup.IMode;
import de.mossgrabers.framework.featuregroup.ModeManager;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.ControlOnlyView;
import de.mossgrabers.framework.view.Views;
import java.util.Optional;

public class ControlView
extends ControlOnlyView<SLControlSurface, SLConfiguration>
implements SLView {
    private boolean isTempoDec;
    private boolean isTempoInc;
    private final TransportControl transportControl;
    private final NewCommand<SLControlSurface, SLConfiguration> newCommand;

    public ControlView(SLControlSurface surface, IModel model) {
        super(surface, model);
        this.newCommand = new NewCommand(model, surface);
        this.transportControl = new TransportControl(surface, model);
    }

    @Override
    public void onButtonRow1(int index, ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        ModeManager modeManager = ((SLControlSurface)this.surface).getModeManager();
        Modes activeModeId = (Modes)((Object)modeManager.getActiveID());
        if (Modes.VIEW_SELECT == activeModeId) {
            if (index == 1) {
                ((SLControlSurface)this.surface).getViewManager().setActive(Views.PLAY);
                if (Modes.VOLUME.equals(modeManager.getPreviousID())) {
                    modeManager.restore();
                } else {
                    modeManager.setActive(Modes.SESSION);
                }
            } else {
                modeManager.restore();
            }
            ((SLControlSurface)this.surface).turnOffTransport();
            return;
        }
        if (!Modes.FUNCTIONS.equals((Object)activeModeId) && !Modes.FIXED.equals((Object)activeModeId)) {
            modeManager.setActive(Modes.FUNCTIONS);
            activeModeId = Modes.FUNCTIONS;
        }
        if (Modes.FIXED.equals((Object)activeModeId)) {
            ((SLConfiguration)((SLControlSurface)this.surface).getConfiguration()).setNewClipLength(index);
            return;
        }
        switch (index) {
            case 0: {
                this.model.getApplication().undo();
                break;
            }
            case 1: {
                this.model.getApplication().redo();
                break;
            }
            case 2: {
                this.model.getApplication().deleteSelection();
                break;
            }
            case 3: {
                this.model.getApplication().duplicate();
                break;
            }
            case 4: {
                this.newCommand.execute();
                break;
            }
            case 5: {
                this.model.getCursorDevice().toggleWindowOpen();
                break;
            }
            case 6: {
                this.model.getTransport().toggleMetronome();
                break;
            }
            case 7: {
                this.model.getTransport().tapTempo();
                break;
            }
        }
    }

    @Override
    public void onButtonRow2(int index, ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        ModeManager modeManager = ((SLControlSurface)this.surface).getModeManager();
        Modes cm = (Modes)((Object)modeManager.getActiveID());
        if (!(Modes.TRACK_DETAILS.equals((Object)cm) || Modes.FRAME.equals((Object)cm) || Modes.BROWSER.equals((Object)cm))) {
            modeManager.setActive(Modes.TRACK_DETAILS);
            cm = Modes.TRACK_DETAILS;
        }
        if (Modes.FRAME.equals((Object)cm)) {
            ((IMode)modeManager.get(Modes.FRAME)).onButton(0, index, event);
            return;
        }
        if (Modes.BROWSER.equals((Object)cm)) {
            ((IMode)modeManager.get(Modes.BROWSER)).onButton(0, index, event);
            return;
        }
        switch (index) {
            case 0: {
                this.model.getCursorTrack().toggleMute();
                break;
            }
            case 1: {
                this.model.getCursorTrack().toggleSolo();
                break;
            }
            case 2: {
                this.model.getCursorTrack().toggleRecArm();
                break;
            }
            case 3: {
                this.model.getTransport().toggleWriteArrangerAutomation();
                break;
            }
            case 4: {
                this.model.getBrowser().replace(this.model.getCursorDevice());
                modeManager.setTemporary(Modes.BROWSER);
                break;
            }
            case 5: {
                this.model.getCursorDevice().toggleEnabledState();
                break;
            }
            case 6: {
                this.model.getCursorDevice().selectPrevious();
                break;
            }
            case 7: {
                this.model.getCursorDevice().selectNext();
                break;
            }
        }
    }

    @Override
    public void onButtonRow3(int index, ButtonEvent event) {
        if (event == ButtonEvent.UP) {
            ((ITrack)this.model.getCurrentTrackBank().getItem(index)).selectOrExpandGroup();
        }
    }

    @Override
    public void onButtonRow4(int index, ButtonEvent event) {
        switch (index) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this.transportControl.execute(index, event);
                break;
            }
            case 6: {
                if (event == ButtonEvent.DOWN) {
                    this.isTempoDec = true;
                } else if (event == ButtonEvent.UP) {
                    this.isTempoDec = false;
                }
                this.doChangeTempo();
                break;
            }
            case 7: {
                if (event == ButtonEvent.DOWN) {
                    this.isTempoInc = true;
                } else if (event == ButtonEvent.UP) {
                    this.isTempoInc = false;
                }
                this.doChangeTempo();
                break;
            }
        }
    }

    @Override
    public void onButtonRow5(int index, ButtonEvent event) {
        this.transportControl.execute(index, event);
    }

    private void doChangeTempo() {
        if (!this.isTempoInc && !this.isTempoDec) {
            return;
        }
        this.model.getTransport().changeTempo(this.isTempoInc, ((SLControlSurface)this.surface).isKnobSensitivitySlow());
        ((SLControlSurface)this.surface).scheduleTask(this::doChangeTempo, 200L);
    }

    @Override
    public void onButtonRow1Select() {
        ModeManager modeManager;
        boolean selectFixed = Modes.FUNCTIONS.equals((modeManager = ((SLControlSurface)this.surface).getModeManager()).getActiveID());
        modeManager.setActive(selectFixed ? Modes.FIXED : Modes.FUNCTIONS);
        this.model.getHost().showNotification(selectFixed ? "Fixed Length" : "Functions");
    }

    @Override
    public void onButtonRow2Select() {
        ModeManager modeManager;
        boolean selectFrame = Modes.TRACK_DETAILS.equals((modeManager = ((SLControlSurface)this.surface).getModeManager()).getActiveID());
        modeManager.setActive(selectFrame ? Modes.FRAME : Modes.TRACK_DETAILS);
        this.model.getHost().showNotification(selectFrame ? "Layouts & Panels" : "Track & Device");
    }

    @Override
    public void onButtonP1(boolean isUp, ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        ModeManager modeManager = ((SLControlSurface)this.surface).getModeManager();
        switch ((Modes)((Object)modeManager.getActiveID())) {
            case FUNCTIONS: 
            case FIXED: {
                this.onButtonRow1Select();
                break;
            }
            case VOLUME: {
                new P2ButtonCommand(isUp, this.model, (SLControlSurface)this.surface).execute(ButtonEvent.DOWN, 127);
                break;
            }
            case TRACK: {
                new ButtonRowSelectCommand(3, this.model, (SLControlSurface)this.surface).execute(ButtonEvent.DOWN, 127);
                break;
            }
            case TRACK_DETAILS: 
            case FRAME: {
                this.onButtonRow2Select();
                break;
            }
            default: {
                SLParameterMode deviceParamsMode = (SLParameterMode)modeManager.get(Modes.DEVICE_PARAMS);
                if (isUp) {
                    deviceParamsMode.selectNextItemPage();
                    break;
                }
                deviceParamsMode.selectPreviousItemPage();
            }
        }
    }

    @Override
    public int getButtonColor(ButtonID buttonID) {
        ITrackBank tb = this.model.getCurrentTrackBank();
        ICursorDevice cd = this.model.getCursorDevice();
        ITransport transport = this.model.getTransport();
        int clipLength = ((SLConfiguration)((SLControlSurface)this.surface).getConfiguration()).getNewClipLength();
        Modes mode = (Modes)((Object)((SLControlSurface)this.surface).getModeManager().getActiveID());
        boolean isFunctions = Modes.FUNCTIONS.equals((Object)mode);
        boolean isViewSelectMode = Modes.VIEW_SELECT.equals((Object)mode);
        switch (buttonID) {
            case ROW1_1: {
                if (isViewSelectMode) {
                    return 0;
                }
                return !isFunctions && clipLength == 0 ? 1 : 0;
            }
            case ROW1_2: {
                if (isViewSelectMode) {
                    return 0;
                }
                return !isFunctions && clipLength == 1 ? 1 : 0;
            }
            case ROW1_3: {
                if (isViewSelectMode) {
                    return 0;
                }
                return !isFunctions && clipLength == 2 ? 1 : 0;
            }
            case ROW1_4: {
                if (isViewSelectMode) {
                    return 0;
                }
                return !isFunctions && clipLength == 3 ? 1 : 0;
            }
            case ROW1_5: {
                if (isViewSelectMode) {
                    return 0;
                }
                return !isFunctions && clipLength == 4 ? 1 : 0;
            }
            case ROW1_6: {
                if (isViewSelectMode) {
                    return 0;
                }
                return isFunctions && this.model.getCursorDevice().isWindowOpen() || !isFunctions && clipLength == 5 ? 1 : 0;
            }
            case ROW1_7: {
                if (isViewSelectMode) {
                    return 0;
                }
                return isFunctions && transport.isMetronomeOn() || !isFunctions && clipLength == 6 ? 1 : 0;
            }
            case ROW1_8: {
                if (isViewSelectMode) {
                    return 0;
                }
                return !isFunctions && clipLength == 7 ? 1 : 0;
            }
        }
        if (Modes.BROWSER.equals((Object)mode)) {
            int selMode = ((DevicePresetsMode)((SLControlSurface)this.surface).getModeManager().get(Modes.BROWSER)).getSelectionMode();
            switch (buttonID) {
                case ROW2_1: 
                case ROW2_2: 
                case ROW2_8: {
                    return 1;
                }
                case ROW2_3: 
                case ROW2_4: 
                case ROW2_5: 
                case ROW2_6: 
                case ROW2_7: {
                    return selMode == 0 ? 1 : 0;
                }
            }
        } else {
            boolean isNoOverlayMode = !Modes.FRAME.equals((Object)mode) && !Modes.BROWSER.equals((Object)mode);
            Optional track = tb.getSelectedItem();
            switch (buttonID) {
                case ROW2_1: {
                    return isNoOverlayMode && track.isPresent() && ((ITrack)track.get()).isMute() ? 1 : 0;
                }
                case ROW2_2: {
                    return isNoOverlayMode && track.isPresent() && ((ITrack)track.get()).isSolo() ? 1 : 0;
                }
                case ROW2_3: {
                    return isNoOverlayMode && track.isPresent() && ((ITrack)track.get()).isRecArm() ? 1 : 0;
                }
                case ROW2_4: {
                    return transport.isWritingArrangerAutomation() ? 1 : 0;
                }
                case ROW2_5: {
                    return 0;
                }
                case ROW2_6: {
                    return this.model.getCursorDevice().isEnabled() ? 1 : 0;
                }
                case ROW2_7: {
                    return isNoOverlayMode && cd.canSelectPrevious() ? 1 : 0;
                }
                case ROW2_8: {
                    return isNoOverlayMode && cd.canSelectNext() ? 1 : 0;
                }
            }
        }
        int buttonIDOrdinal = buttonID.ordinal();
        if (buttonIDOrdinal >= ButtonID.ROW3_1.ordinal() && buttonIDOrdinal <= ButtonID.ROW3_8.ordinal()) {
            int index = buttonIDOrdinal - ButtonID.ROW3_1.ordinal();
            return ((ITrack)tb.getItem(index)).isSelected() ? 1 : 0;
        }
        boolean isTrack = Modes.TRACK.equals((Object)mode);
        boolean isTrackToggles = Modes.TRACK_DETAILS.equals((Object)mode);
        boolean isVolume = Modes.VOLUME.equals((Object)mode);
        boolean isFixed = Modes.FIXED.equals((Object)mode);
        boolean isFrame = Modes.FRAME.equals((Object)mode);
        boolean isPreset = Modes.BROWSER.equals((Object)mode);
        boolean isDevice = Modes.DEVICE_PARAMS.equals((Object)mode);
        switch (buttonID) {
            case ROW4_3: {
                return !transport.isPlaying() ? 1 : 0;
            }
            case ROW4_4: {
                return transport.isPlaying() ? 1 : 0;
            }
            case ROW4_5: {
                return transport.isLoop() ? 1 : 0;
            }
            case ROW4_6: {
                return transport.isRecording() ? 1 : 0;
            }
            case ROW_SELECT_1: {
                return isFunctions || isFixed ? 1 : 0;
            }
            case ROW_SELECT_2: {
                return isDevice ? 1 : 0;
            }
            case ROW_SELECT_3: {
                return isTrackToggles || isFrame || isPreset ? 1 : 0;
            }
            case ROW_SELECT_4: {
                return isTrack ? 1 : 0;
            }
            case ROW_SELECT_6: {
                return isVolume ? 1 : 0;
            }
            case ROW_SELECT_7: {
                return 0;
            }
        }
        return 0;
    }

    @Override
    public void onGridNote(int note, int velocity) {
        if (((SLConfiguration)((SLControlSurface)this.surface).getConfiguration()).isDrumpadsAsModeSelection()) {
            if (velocity > 0) {
                int index = note - 36;
                new ButtonRowSelectCommand(index > 3 ? 5 : index, this.model, (SLControlSurface)this.surface).execute(ButtonEvent.DOWN, 127);
            }
            return;
        }
        ((SLControlSurface)this.surface).sendMidiEvent(144, note, velocity);
    }
}

