/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.launchpad.command.trigger;

import de.mossgrabers.controller.novation.launchpad.LaunchpadConfiguration;
import de.mossgrabers.controller.novation.launchpad.controller.LaunchpadControlSurface;
import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.featuregroup.ModeManager;
import de.mossgrabers.framework.featuregroup.ViewManager;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.Views;

public class AbstractTrackCommand
extends AbstractTriggerCommand<LaunchpadControlSurface, LaunchpadConfiguration> {
    private boolean firstRowUsed;
    private boolean wasSession;
    private boolean temporaryView;

    public AbstractTrackCommand(IModel model, LaunchpadControlSurface surface) {
        super(model, surface);
    }

    protected void onModeButton(ButtonEvent event, Modes controlMode, String notification) {
        ModeManager modeManager = ((LaunchpadControlSurface)this.surface).getModeManager();
        ViewManager viewManager = ((LaunchpadControlSurface)this.surface).getViewManager();
        switch (event) {
            case DOWN: {
                this.firstRowUsed = false;
                if (modeManager.isActive(new Modes[]{controlMode})) {
                    modeManager.setActive(Modes.DUMMY);
                    return;
                }
                modeManager.setActive(controlMode);
                this.wasSession = viewManager.isActive(new Views[]{Views.SESSION});
                if (!this.wasSession) {
                    viewManager.setActive(Views.SESSION);
                }
                ((LaunchpadControlSurface)this.surface).getDisplay().notify(notification);
                if (!((LaunchpadControlSurface)this.surface).isPressed(ButtonID.TRACK)) break;
                this.wasSession = true;
                break;
            }
            case LONG: {
                this.firstRowUsed = true;
                break;
            }
            case UP: {
                if (!this.firstRowUsed) break;
                modeManager.setActive(Modes.DUMMY);
                if (this.wasSession) break;
                viewManager.restore();
            }
        }
    }

    protected void onFaderModeButton(ButtonEvent event, Views view, String notification) {
        ViewManager viewManager = ((LaunchpadControlSurface)this.surface).getViewManager();
        switch (event) {
            case DOWN: {
                if (viewManager.isActive(new Views[]{view})) {
                    ((LaunchpadControlSurface)this.surface).getViewManager().setActive(Views.SESSION);
                    return;
                }
                this.temporaryView = false;
                ((LaunchpadControlSurface)this.surface).getModeManager().setActive(Modes.DUMMY);
                viewManager.setActive(view);
                ((LaunchpadControlSurface)this.surface).getDisplay().notify(notification);
                break;
            }
            case LONG: {
                this.temporaryView = true;
                break;
            }
            case UP: {
                if (!this.temporaryView) break;
                viewManager.restore();
            }
        }
    }
}

