/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ni.maschine.mk3.mode;

import de.mossgrabers.controller.ni.maschine.mk3.controller.MaschineControlSurface;
import de.mossgrabers.controller.ni.maschine.mk3.mode.BaseMode;
import de.mossgrabers.framework.controller.display.ITextDisplay;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.ITransport;

public class LoopStartMode
extends BaseMode {
    public LoopStartMode(MaschineControlSurface surface, IModel model) {
        super("Loop Start", surface, model);
    }

    @Override
    public void onKnobValue(int index, int value) {
        double speed = this.model.getValueChanger().calcKnobChange(value);
        this.model.getTransport().changeLoopStart(speed > 0.0, ((MaschineControlSurface)this.surface).isKnobSensitivitySlow());
    }

    @Override
    public void updateDisplay() {
        ITextDisplay d = ((MaschineControlSurface)this.surface).getTextDisplay().clear();
        ITransport transport = this.model.getTransport();
        d.setBlock(0, 0, "Arranger Loop");
        d.setBlock(0, 2, "Start:").setBlock(0, 3, "> " + transport.getLoopStartBeatText());
        d.setBlock(1, 2, "Length:").setBlock(1, 3, "  " + transport.getLoopLengthBeatText());
        d.allDone();
    }
}

