/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ni.kontrol.mkii.mode;

import de.mossgrabers.controller.ni.kontrol.mkii.KontrolProtocolConfiguration;
import de.mossgrabers.controller.ni.kontrol.mkii.controller.KontrolProtocolControlSurface;
import de.mossgrabers.framework.controller.ContinuousID;
import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ICursorDevice;
import de.mossgrabers.framework.daw.data.bank.IDeviceBank;
import de.mossgrabers.framework.daw.data.bank.IParameterBank;
import de.mossgrabers.framework.daw.data.bank.IParameterPageBank;
import de.mossgrabers.framework.featuregroup.AbstractParameterMode;
import de.mossgrabers.framework.parameter.IParameter;
import de.mossgrabers.framework.parameterprovider.IParameterProvider;
import de.mossgrabers.framework.parameterprovider.device.BankParameterProvider;
import de.mossgrabers.framework.parameterprovider.special.CombinedParameterProvider;
import de.mossgrabers.framework.utils.StringUtils;
import java.util.List;
import java.util.Optional;

public class FakeParamsMode
extends AbstractParameterMode<KontrolProtocolControlSurface, KontrolProtocolConfiguration, IParameter> {
    private static final String[] BANK_NAMES = new String[]{"Cursor Device ", "Track ", "Project "};
    private final IParameterBank[] banks;
    private final IParameterProvider[] providers = new IParameterProvider[3];
    private int activeProviderIndex = 0;

    public FakeParamsMode(KontrolProtocolControlSurface surface, IModel model, List<ContinuousID> controls) {
        super("Parameters", surface, model, false);
        this.setControls(controls);
        this.banks = new IParameterBank[]{model.getCursorDevice().getParameterBank(), model.getCursorTrack().getParameterBank(), model.getProject().getParameterBank()};
        for (int i = 0; i < this.banks.length; ++i) {
            BankParameterProvider cursorDeviceProvider = new BankParameterProvider(this.banks[i]);
            this.providers[i] = new CombinedParameterProvider(cursorDeviceProvider, cursorDeviceProvider);
        }
        this.selectProvider(0);
    }

    @Override
    public int getKnobValue(int index) {
        IValueChanger valueChanger = this.model.getValueChanger();
        if (index >= 80 && index < 88) {
            IParameter parameter = (IParameter)this.bank.getItem(index - 80);
            return valueChanger.toMidiValue(parameter.getValue());
        }
        if (index >= 88 && index < 96) {
            IParameter parameter = (IParameter)this.bank.getItem(index - 88);
            return valueChanger.toMidiValue(parameter.getValue());
        }
        ICursorDevice cursorDevice = this.model.getCursorDevice();
        IDeviceBank deviceBank = cursorDevice.getDeviceBank();
        switch (index) {
            case 49: {
                return (this.bank.canScrollBackwards() ? 1 : 0) + (this.bank.canScrollForwards() ? 2 : 0);
            }
            case 48: {
                return (deviceBank.canScrollBackwards() ? 1 : 0) + (deviceBank.canScrollForwards() ? 2 : 0);
            }
            case 50: {
                return (this.activeProviderIndex > 0 ? 1 : 0) + (this.activeProviderIndex < 2 ? 2 : 0);
            }
        }
        return 0;
    }

    @Override
    public void updateDisplay() {
        ((KontrolProtocolControlSurface)this.surface).sendGlobalValues(this.model);
        IValueChanger valueChanger = this.model.getValueChanger();
        IParameterPageBank parameterPageBank = this.banks[this.activeProviderIndex].getPageBank();
        Optional selectedItem = parameterPageBank.getSelectedItem();
        String selectedPage = selectedItem.isPresent() ? StringUtils.optimizeName((String)selectedItem.get(), 8) : "";
        int[] vuData = new int[16];
        for (int i = 0; i < 8; ++i) {
            IParameter parameter = (IParameter)this.bank.getItem(i);
            ((KontrolProtocolControlSurface)this.surface).sendKontrolSysEx(64, 1, i);
            ((KontrolProtocolControlSurface)this.surface).sendKontrolSysEx(66, parameter.isSelected() ? 1 : 0, i);
            ((KontrolProtocolControlSurface)this.surface).sendKontrolSysEx(69, 0, i);
            String info = parameter.doesExist() ? parameter.getDisplayedValue(8) : " ";
            ((KontrolProtocolControlSurface)this.surface).sendKontrolSysEx(70, 0, i, info);
            ((KontrolProtocolControlSurface)this.surface).sendKontrolSysEx(71, 0, i, info);
            String name = this.getLabel(selectedPage, parameter);
            ((KontrolProtocolControlSurface)this.surface).sendKontrolSysEx(72, 0, i, name);
            int j = 2 * i;
            vuData[j] = valueChanger.toMidiValue(parameter.getModulatedValue());
            vuData[j + 1] = valueChanger.toMidiValue(parameter.getModulatedValue());
            ((KontrolProtocolControlSurface)this.surface).sendKontrolSysEx(67, 0, i);
            ((KontrolProtocolControlSurface)this.surface).sendKontrolSysEx(68, 0, i);
            ((KontrolProtocolControlSurface)this.surface).sendKontrolSysEx(74, 0, i);
            ((KontrolProtocolControlSurface)this.surface).sendCommand(104, 0);
            ((KontrolProtocolControlSurface)this.surface).sendCommand(105, 0);
        }
        ((KontrolProtocolControlSurface)this.surface).sendKontrolSysEx(73, 2, 0, vuData);
    }

    @Override
    public void selectPreviousItem() {
        this.model.getCursorDevice().selectPrevious();
    }

    @Override
    public void selectNextItem() {
        this.model.getCursorDevice().selectNext();
    }

    @Override
    public void selectPreviousItemPage() {
        this.bank.scrollBackwards();
    }

    @Override
    public void selectNextItemPage() {
        this.bank.scrollForwards();
    }

    private String getLabel(String selectedPage, IParameter parameter) {
        String n;
        String string = n = parameter.doesExist() ? parameter.getName(16) : "None";
        if (((KontrolProtocolControlSurface)this.surface).getProtocolVersion() == 1) {
            return n;
        }
        return (switch (this.activeProviderIndex) {
            default -> this.model.getCursorDevice().getName(8);
            case 1 -> "Track";
            case 2 -> "Project";
        }) + "\n" + selectedPage + "\n" + n;
    }

    public void switchProvider(boolean isLeft) {
        this.selectProvider(isLeft ? this.activeProviderIndex - 1 : this.activeProviderIndex + 1);
    }

    private void selectProvider(int index) {
        this.activeProviderIndex = Math.clamp((long)index, 0, 2);
        this.switchBanks(this.banks[this.activeProviderIndex]);
        this.setParameterProvider(this.providers[this.activeProviderIndex]);
        this.bindControls();
        this.mvHelper.notifySelectedParameterPage(this.banks[this.activeProviderIndex], BANK_NAMES[this.activeProviderIndex]);
    }
}

