/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ni.kontrol.mkii.command.trigger;

import de.mossgrabers.controller.ni.kontrol.mkii.KontrolProtocolConfiguration;
import de.mossgrabers.controller.ni.kontrol.mkii.controller.KontrolProtocolControlSurface;
import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.command.trigger.clip.StartClipCommand;
import de.mossgrabers.framework.command.trigger.clip.StartSceneCommand;
import de.mossgrabers.framework.daw.IBrowser;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.utils.ButtonEvent;

public class StartClipOrSceneCommand
extends AbstractTriggerCommand<KontrolProtocolControlSurface, KontrolProtocolConfiguration> {
    private final StartClipCommand<KontrolProtocolControlSurface, KontrolProtocolConfiguration> clipCommand;
    private final StartSceneCommand<KontrolProtocolControlSurface, KontrolProtocolConfiguration> sceneCommand;

    public StartClipOrSceneCommand(IModel model, KontrolProtocolControlSurface surface) {
        super(model, surface);
        this.clipCommand = new StartClipCommand(model, surface);
        this.sceneCommand = new StartSceneCommand(model, surface);
    }

    @Override
    public void execute(ButtonEvent event, int velocity) {
        IBrowser browser = this.model.getBrowser();
        if (browser.isActive()) {
            browser.stopBrowsing(true);
            return;
        }
        if (((KontrolProtocolControlSurface)this.surface).getModeManager().isActive(new Modes[]{Modes.VOLUME})) {
            if (((KontrolProtocolConfiguration)((KontrolProtocolControlSurface)this.surface).getConfiguration()).isFlipClipSceneNavigation()) {
                this.sceneCommand.execute(event, velocity);
            } else {
                this.clipCommand.execute(event, velocity);
            }
            return;
        }
        if (event == ButtonEvent.DOWN) {
            this.model.getCursorDevice().toggleWindowOpen();
        }
    }
}

