/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.mackie.mcu.controller;

import de.mossgrabers.controller.mackie.mcu.MCUConfiguration;
import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.display.AbstractTextDisplay;
import de.mossgrabers.framework.controller.display.ITextDisplay;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.midi.IMidiOutput;
import de.mossgrabers.framework.utils.LatestTaskExecutor;
import de.mossgrabers.framework.utils.StringUtils;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class MCUDisplay
extends AbstractTextDisplay {
    private static final String SYSEX_DISPLAY_HEADER = "F0 00 00 66 ";
    private static final String SYSEX_DISPLAY_HEADER_MAIN = "F0 00 00 66 14 ";
    private static final String SYSEX_DISPLAY_HEADER1_MAIN = "F0 00 00 66 14 12 ";
    private static final String SYSEX_DISPLAY_HEADER1_EXTENDER = "F0 00 00 66 15 12 ";
    private static final String SYSEX_DISPLAY_HEADER2 = "F0 00 00 67 15 13 ";
    private final boolean isFirstDisplay;
    private final boolean isExtender;
    private final boolean isMainDevice;
    private final Configuration configuration;
    private final LatestTaskExecutor[] executors = new LatestTaskExecutor[4];
    private boolean isShutdown = false;
    private boolean insertSpace = true;

    public MCUDisplay(IHost host, IMidiOutput output, boolean isFirst, boolean isMCUExtender, boolean isMainDevice, Configuration configuration) {
        super(host, output, 2, !isFirst && isMainDevice ? 9 : 8, 56);
        this.isFirstDisplay = isFirst;
        this.isMainDevice = isMainDevice;
        this.isExtender = isMCUExtender;
        this.configuration = configuration;
        this.centerNotification = false;
        for (int i = 0; i < this.executors.length; ++i) {
            this.executors[i] = new LatestTaskExecutor();
        }
    }

    public void updateShortSecondDisplay() {
        Configuration configuration;
        if (!this.isFirstDisplay && this.isMainDevice && (configuration = this.configuration) instanceof MCUConfiguration) {
            MCUConfiguration conf = (MCUConfiguration)configuration;
            this.setNumberOfCells(this.noOfLines, conf.getSecondDisplayType() == MCUConfiguration.SecondDisplay.QCON ? 9 : 8, this.noOfCharacters);
        }
    }

    public void insertSpace(boolean enable) {
        this.insertSpace = enable;
    }

    public void changeDisplaySize(int numberOfCharacters) {
        this.setNumberOfCells(this.noOfLines, this.noOfCells, numberOfCharacters);
    }

    @Override
    public ITextDisplay setCell(int row, int column, String value) {
        try {
            Object content = this.insertSpace ? StringUtils.pad(value, this.charactersOfCell - 1) + " " : StringUtils.pad(value, this.charactersOfCell);
            this.cells[row * this.noOfCells + column] = content;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            this.host.error("Display array index out of bounds.", ex);
        }
        return this;
    }

    @Override
    protected void updateLine(int row, String text, String previousText) {
        MCUConfiguration conf;
        Configuration configuration;
        Object t = text;
        if (!this.isFirstDisplay && this.isMainDevice && (configuration = this.configuration) instanceof MCUConfiguration && (conf = (MCUConfiguration)configuration).getSecondDisplayType() == MCUConfiguration.SecondDisplay.QCON) {
            if (row == 0) {
                t = ((String)t).substring(0, ((String)t).length() - 1) + "r";
            }
            t = "  " + (String)t;
        }
        super.updateLine(row, (String)t, previousText);
    }

    @Override
    public void writeLine(int row, String text, String previousText) {
        if (this.isShutdown) {
            return;
        }
        LatestTaskExecutor executor = this.executors[row + (this.isFirstDisplay ? 0 : 2)];
        executor.execute(() -> {
            try {
                int offset = 0;
                String t = text;
                if (this.isAsparion() && previousText != null && text.length() == previousText.length()) {
                    for (int i = 0; i < text.length(); ++i) {
                        if (text.charAt(i) == previousText.charAt(i)) continue;
                        offset = i;
                        break;
                    }
                    int end = offset + 1;
                    for (int i = previousText.length() - 1; i > offset; --i) {
                        if (text.charAt(i) == previousText.charAt(i)) continue;
                        end = i;
                        break;
                    }
                    t = text.substring(offset, end + 1);
                }
                String hexStr = StringUtils.toHexStr(t.getBytes());
                this.output.sendSysex(this.getHeader(row, offset) + hexStr + "F7");
            }
            catch (RuntimeException ex) {
                this.host.error("Could not send line to MCU display.", ex);
            }
        });
    }

    private String getHeader(int row, int offset) {
        StringBuilder header = new StringBuilder();
        boolean isAsparion = this.isAsparion();
        if (this.isFirstDisplay) {
            if (isAsparion) {
                header.append(SYSEX_DISPLAY_HEADER_MAIN).append("1A ").append(StringUtils.toHexStr(offset)).append(' ').append(row == 0 ? "01 " : "02 ");
            } else {
                header.append(this.isExtender ? SYSEX_DISPLAY_HEADER1_EXTENDER : SYSEX_DISPLAY_HEADER1_MAIN);
            }
        } else if (isAsparion) {
            header.append(SYSEX_DISPLAY_HEADER_MAIN).append("19 ").append(StringUtils.toHexStr(offset)).append(' ');
        } else {
            header.append(SYSEX_DISPLAY_HEADER2);
        }
        if (!isAsparion) {
            header.append(row == 0 ? "00 " : "38 ");
        }
        return header.toString();
    }

    @Override
    public void shutdown() {
        if (this.isShutdown) {
            return;
        }
        this.clear().allDone();
        this.flush();
        this.isShutdown = true;
        ExecutorService shutdownExecutor = Executors.newSingleThreadExecutor();
        shutdownExecutor.execute(() -> {
            for (LatestTaskExecutor executor : this.executors) {
                executor.shutdown();
                try {
                    if (executor.awaitTermination(5L, TimeUnit.SECONDS)) continue;
                    this.host.error("MCU display send executor did not end in 5 seconds.");
                }
                catch (InterruptedException ex) {
                    this.host.error("MCU display send executor interrupted.", ex);
                    Thread.currentThread().interrupt();
                }
            }
        });
        shutdownExecutor.shutdown();
        try {
            if (!shutdownExecutor.awaitTermination(10L, TimeUnit.SECONDS)) {
                this.host.error("MCU display shutdown executor did not end in 10 seconds.");
            }
        }
        catch (InterruptedException ex) {
            this.host.error("Display shutdown interrupted.", ex);
            Thread.currentThread().interrupt();
        }
    }

    private boolean isAsparion() {
        MCUConfiguration conf;
        Configuration configuration = this.configuration;
        return configuration instanceof MCUConfiguration && (conf = (MCUConfiguration)configuration).getMainDisplayType() == MCUConfiguration.MainDisplay.ASPARION;
    }
}

