/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.mackie.mcu.command.trigger;

import de.mossgrabers.controller.mackie.mcu.MCUConfiguration;
import de.mossgrabers.controller.mackie.mcu.controller.MCUControlSurface;
import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.featuregroup.ModeManager;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.utils.ButtonEvent;

public class KeyCommand
extends AbstractTriggerCommand<MCUControlSurface, MCUConfiguration> {
    protected Key key;

    public KeyCommand(Key key, IModel model, MCUControlSurface surface) {
        super(model, surface);
        this.key = key;
    }

    @Override
    public void execute(ButtonEvent event, int velocity) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        ModeManager modeManager = ((MCUControlSurface)this.surface).getModeManager();
        switch (this.key.ordinal()) {
            case 0: {
                if (modeManager.isActive(new Modes[]{Modes.BROWSER})) {
                    this.model.getBrowser().stopBrowsing(true);
                    modeManager.restore();
                    break;
                }
                this.model.getApplication().enter();
                break;
            }
            case 1: {
                if (modeManager.isActive(new Modes[]{Modes.BROWSER})) {
                    this.model.getBrowser().stopBrowsing(false);
                    modeManager.restore();
                    break;
                }
                this.model.getApplication().escape();
                break;
            }
        }
    }

    public static enum Key {
        ENTER,
        ESCAPE;

    }
}

