/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.mackie.hui.mode.track;

import de.mossgrabers.controller.mackie.hui.HUIConfiguration;
import de.mossgrabers.controller.mackie.hui.controller.HUIControlSurface;
import de.mossgrabers.controller.mackie.hui.mode.track.AbstractTrackMode;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ISend;
import de.mossgrabers.framework.daw.data.ITrack;
import java.util.Optional;

public class SendMode
extends AbstractTrackMode {
    private static final String[] SEND_NAMES = new String[]{"Send A", "Send B", "Send C", "Send D", "Send E", "Send F"};
    private static final String[] SEND_NAMES_SHORT = new String[]{"SndA", "SndB", "SndC", "SndD", "SndE", "SndF"};
    private final int sendIndex;

    public SendMode(int sendIndex, HUIControlSurface surface, IModel model) {
        super(SEND_NAMES[sendIndex], surface, model);
        this.sendIndex = sendIndex;
    }

    @Override
    public void onKnobValue(int index, int value) {
        Optional<ITrack> track = this.getTrack(index);
        if (track.isPresent()) {
            ((ISend)track.get().getSendBank().getItem(this.sendIndex)).changeValue(value);
        }
    }

    @Override
    public void updateDisplay() {
        if (((HUIConfiguration)((HUIControlSurface)this.surface).getConfiguration()).hasDisplay1()) {
            this.drawTrackHeader().setCell(0, 8, SEND_NAMES_SHORT[this.sendIndex]).done(0);
        }
    }

    @Override
    public void updateKnobLEDs() {
        int upperBound = this.model.getValueChanger().getUpperBound();
        for (int i = 0; i < 8; ++i) {
            Optional<ITrack> track = this.getTrack(i);
            ((HUIControlSurface)this.surface).setKnobLED(i, 2, track.isPresent() ? ((ISend)track.get().getSendBank().getItem(this.sendIndex)).getValue() : 0, upperBound);
        }
    }

    @Override
    public void resetParameter(int index) {
        Optional<ITrack> track = this.getTrack(index);
        if (track.isPresent()) {
            ((ISend)track.get().getSendBank().getItem(this.sendIndex)).resetValue();
        }
    }

    @Override
    public String getName() {
        ISend send;
        Optional selectedTrack = this.model.getTrackBank().getSelectedItem();
        String name = "-";
        if (selectedTrack.isPresent() && (send = (ISend)((ITrack)selectedTrack.get()).getSendBank().getItem(this.sendIndex)).doesExist()) {
            name = send.getName();
        }
        return super.getName() + ": " + name;
    }
}

