/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.mackie.hui.command.trigger;

import de.mossgrabers.controller.mackie.hui.HUIConfiguration;
import de.mossgrabers.controller.mackie.hui.controller.HUIControlSurface;
import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.command.trigger.Direction;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.utils.ButtonEvent;

public class ZoomAndKeysCursorCommand
extends AbstractTriggerCommand<HUIControlSurface, HUIConfiguration> {
    protected Direction direction;

    public ZoomAndKeysCursorCommand(Direction direction, IModel model, HUIControlSurface surface) {
        super(model, surface);
        this.direction = direction;
    }

    @Override
    public void execute(ButtonEvent event, int velocity) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        switch (this.direction) {
            case LEFT: {
                this.scrollLeft();
                break;
            }
            case RIGHT: {
                this.scrollRight();
                break;
            }
            case UP: {
                this.scrollUp();
                break;
            }
            case DOWN: {
                this.scrollDown();
            }
        }
    }

    protected void scrollLeft() {
        if (((HUIConfiguration)((HUIControlSurface)this.surface).getConfiguration()).isZoomState()) {
            this.model.getApplication().zoomOut();
        } else {
            this.model.getApplication().arrowKeyLeft();
        }
    }

    protected void scrollRight() {
        if (((HUIConfiguration)((HUIControlSurface)this.surface).getConfiguration()).isZoomState()) {
            this.model.getApplication().zoomIn();
        } else {
            this.model.getApplication().arrowKeyRight();
        }
    }

    protected void scrollUp() {
        if (((HUIConfiguration)((HUIControlSurface)this.surface).getConfiguration()).isZoomState()) {
            this.model.getApplication().decTrackHeight();
        } else {
            this.model.getApplication().arrowKeyUp();
        }
    }

    protected void scrollDown() {
        if (((HUIConfiguration)((HUIControlSurface)this.surface).getConfiguration()).isZoomState()) {
            this.model.getApplication().incTrackHeight();
        } else {
            this.model.getApplication().arrowKeyDown();
        }
    }
}

