/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.intuitiveinstruments.exquis.mode;

import de.mossgrabers.controller.intuitiveinstruments.exquis.ExquisConfiguration;
import de.mossgrabers.controller.intuitiveinstruments.exquis.controller.ExquisControlSurface;
import de.mossgrabers.controller.intuitiveinstruments.exquis.mode.ExquisFourKnobProvider;
import de.mossgrabers.controller.intuitiveinstruments.exquis.mode.IExquisMode;
import de.mossgrabers.framework.daw.DAWColor;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.mode.device.ParameterMode;
import de.mossgrabers.framework.parameterprovider.device.BankParameterProvider;

public class ExquisParameterMode
extends ParameterMode<ExquisControlSurface, ExquisConfiguration>
implements IExquisMode {
    private static final int[] PARAM_COLORS = new int[]{DAWColor.DAW_COLOR_RED.ordinal(), DAWColor.DAW_COLOR_ORANGE.ordinal(), DAWColor.DAW_COLOR_LIGHT_ORANGE.ordinal(), DAWColor.DAW_COLOR_GREEN.ordinal()};
    private final ExquisFourKnobProvider exquisParameterProvider;

    public ExquisParameterMode(ExquisControlSurface surface, IModel model) {
        super(surface, model, false);
        this.setControls(ExquisControlSurface.KNOBS);
        this.exquisParameterProvider = new ExquisFourKnobProvider(surface, new BankParameterProvider(this.cursorDevice.getParameterBank()));
        this.setParameterProvider(this.exquisParameterProvider);
    }

    @Override
    public int getKnobColor(int index) {
        return 50 + PARAM_COLORS[index];
    }

    @Override
    public void toggleParameters() {
        this.exquisParameterProvider.toggle();
        this.bindControls();
    }

    public boolean are1To4Bound() {
        return this.exquisParameterProvider.are1To4Bound();
    }
}

