/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.intuitiveinstruments.exquis.command.trigger;

import de.mossgrabers.controller.intuitiveinstruments.exquis.ExquisConfiguration;
import de.mossgrabers.controller.intuitiveinstruments.exquis.controller.ExquisControlSurface;
import de.mossgrabers.controller.intuitiveinstruments.exquis.mode.ExquisProjectTrackParameterMode;
import de.mossgrabers.framework.command.trigger.mode.ModeSelectCommand;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.featuregroup.IMode;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.utils.ButtonEvent;

public class ExquisProjectParameterModeSelectCommand
extends ModeSelectCommand<ExquisControlSurface, ExquisConfiguration> {
    public ExquisProjectParameterModeSelectCommand(IModel model, ExquisControlSurface surface) {
        super(model, surface, Modes.PROJECT_PARAMETERS);
        this.notify = false;
    }

    @Override
    public void executeNormal(ButtonEvent event) {
        if (event == ButtonEvent.DOWN) {
            return;
        }
        if (event == ButtonEvent.LONG) {
            if (this.modeManager.isActive(new Modes[]{Modes.REPEAT_NOTE})) {
                this.modeManager.restore();
            } else {
                this.modeManager.setActive(Modes.REPEAT_NOTE);
            }
            ((ExquisControlSurface)this.surface).setTriggerConsumed(ButtonID.KNOB1_TOUCH);
            ((ExquisControlSurface)this.surface).getDisplay().notify("Arp Configuration Mode: " + (this.modeManager.isActive(new Modes[]{Modes.REPEAT_NOTE}) ? "On" : "Off"));
            return;
        }
        if (this.modeManager.isActive(new Modes[]{Modes.REPEAT_NOTE})) {
            ((IMode)this.modeManager.get(Modes.REPEAT_NOTE)).onKnobTouch(0, true);
            return;
        }
        ExquisProjectTrackParameterMode mode = (ExquisProjectTrackParameterMode)this.modeManager.get(Modes.PROJECT_PARAMETERS);
        if (this.modeManager.isActive(new Modes[]{Modes.PROJECT_PARAMETERS})) {
            mode.toggleParameters();
        } else {
            super.executeNormal(ButtonEvent.DOWN);
        }
        String message = "Project Parameters " + (mode.are1To4Bound() ? "1 - 4" : "5 - 8");
        ((ExquisControlSurface)this.surface).getDisplay().notify(message);
    }
}

