/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.generic.flexihandler;

import de.mossgrabers.controller.generic.GenericFlexiConfiguration;
import de.mossgrabers.controller.generic.controller.FlexiCommand;
import de.mossgrabers.controller.generic.controller.GenericFlexiControlSurface;
import de.mossgrabers.controller.generic.flexihandler.AbstractHandler;
import de.mossgrabers.controller.generic.flexihandler.utils.FlexiHandlerException;
import de.mossgrabers.controller.generic.flexihandler.utils.KnobMode;
import de.mossgrabers.controller.generic.flexihandler.utils.MidiValue;
import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ICursorDevice;
import de.mossgrabers.framework.daw.data.ILayer;
import de.mossgrabers.framework.daw.data.ISend;
import de.mossgrabers.framework.daw.data.bank.ILayerBank;
import de.mossgrabers.framework.daw.data.bank.ISendBank;
import de.mossgrabers.framework.parameter.IParameter;
import java.util.Optional;

public class LayerHandler
extends AbstractHandler {
    public LayerHandler(IModel model, GenericFlexiControlSurface surface, GenericFlexiConfiguration configuration, IValueChanger absoluteLowResValueChanger, IValueChanger signedBitRelativeValueChanger, IValueChanger signedBit2RelativeValueChanger, IValueChanger offsetBinaryRelativeValueChanger) {
        super(model, surface, configuration, absoluteLowResValueChanger, signedBitRelativeValueChanger, signedBit2RelativeValueChanger, offsetBinaryRelativeValueChanger);
    }

    @Override
    public FlexiCommand[] getSupportedCommands() {
        return new FlexiCommand[]{FlexiCommand.LAYER_SELECT_PREVIOUS_BANK_PAGE, FlexiCommand.LAYER_SELECT_NEXT_BANK_PAGE, FlexiCommand.LAYER_SELECT_PREVIOUS_LAYER, FlexiCommand.LAYER_SELECT_NEXT_LAYER, FlexiCommand.LAYER_SCROLL_LAYERS, FlexiCommand.LAYER_1_SELECT, FlexiCommand.LAYER_2_SELECT, FlexiCommand.LAYER_3_SELECT, FlexiCommand.LAYER_4_SELECT, FlexiCommand.LAYER_5_SELECT, FlexiCommand.LAYER_6_SELECT, FlexiCommand.LAYER_7_SELECT, FlexiCommand.LAYER_8_SELECT, FlexiCommand.LAYER_1_TOGGLE_ACTIVE, FlexiCommand.LAYER_2_TOGGLE_ACTIVE, FlexiCommand.LAYER_3_TOGGLE_ACTIVE, FlexiCommand.LAYER_4_TOGGLE_ACTIVE, FlexiCommand.LAYER_5_TOGGLE_ACTIVE, FlexiCommand.LAYER_6_TOGGLE_ACTIVE, FlexiCommand.LAYER_7_TOGGLE_ACTIVE, FlexiCommand.LAYER_8_TOGGLE_ACTIVE, FlexiCommand.LAYER_1_SET_ACTIVE, FlexiCommand.LAYER_2_SET_ACTIVE, FlexiCommand.LAYER_3_SET_ACTIVE, FlexiCommand.LAYER_4_SET_ACTIVE, FlexiCommand.LAYER_5_SET_ACTIVE, FlexiCommand.LAYER_6_SET_ACTIVE, FlexiCommand.LAYER_7_SET_ACTIVE, FlexiCommand.LAYER_8_SET_ACTIVE, FlexiCommand.LAYER_SELECTED_TOGGLE_ACTIVE, FlexiCommand.LAYER_SELECTED_SET_ACTIVE, FlexiCommand.LAYER_1_SET_VOLUME, FlexiCommand.LAYER_2_SET_VOLUME, FlexiCommand.LAYER_3_SET_VOLUME, FlexiCommand.LAYER_4_SET_VOLUME, FlexiCommand.LAYER_5_SET_VOLUME, FlexiCommand.LAYER_6_SET_VOLUME, FlexiCommand.LAYER_7_SET_VOLUME, FlexiCommand.LAYER_8_SET_VOLUME, FlexiCommand.LAYER_SELECTED_SET_VOLUME_LAYER, FlexiCommand.LAYER_1_SET_PANNING, FlexiCommand.LAYER_2_SET_PANNING, FlexiCommand.LAYER_3_SET_PANNING, FlexiCommand.LAYER_4_SET_PANNING, FlexiCommand.LAYER_5_SET_PANNING, FlexiCommand.LAYER_6_SET_PANNING, FlexiCommand.LAYER_7_SET_PANNING, FlexiCommand.LAYER_8_SET_PANNING, FlexiCommand.LAYER_SELECTED_SET_PANNING, FlexiCommand.LAYER_1_TOGGLE_MUTE, FlexiCommand.LAYER_2_TOGGLE_MUTE, FlexiCommand.LAYER_3_TOGGLE_MUTE, FlexiCommand.LAYER_4_TOGGLE_MUTE, FlexiCommand.LAYER_5_TOGGLE_MUTE, FlexiCommand.LAYER_6_TOGGLE_MUTE, FlexiCommand.LAYER_7_TOGGLE_MUTE, FlexiCommand.LAYER_8_TOGGLE_MUTE, FlexiCommand.LAYER_1_SET_MUTE, FlexiCommand.LAYER_2_SET_MUTE, FlexiCommand.LAYER_3_SET_MUTE, FlexiCommand.LAYER_4_SET_MUTE, FlexiCommand.LAYER_5_SET_MUTE, FlexiCommand.LAYER_6_SET_MUTE, FlexiCommand.LAYER_7_SET_MUTE, FlexiCommand.LAYER_8_SET_MUTE, FlexiCommand.LAYER_SELECTED_TOGGLE_MUTE, FlexiCommand.LAYER_SELECTED_SET_MUTE, FlexiCommand.LAYER_1_TOGGLE_SOLO, FlexiCommand.LAYER_2_TOGGLE_SOLO, FlexiCommand.LAYER_3_TOGGLE_SOLO, FlexiCommand.LAYER_4_TOGGLE_SOLO, FlexiCommand.LAYER_5_TOGGLE_SOLO, FlexiCommand.LAYER_6_TOGGLE_SOLO, FlexiCommand.LAYER_7_TOGGLE_SOLO, FlexiCommand.LAYER_8_TOGGLE_SOLO, FlexiCommand.LAYER_1_SET_SOLO, FlexiCommand.LAYER_2_SET_SOLO, FlexiCommand.LAYER_3_SET_SOLO, FlexiCommand.LAYER_4_SET_SOLO, FlexiCommand.LAYER_5_SET_SOLO, FlexiCommand.LAYER_6_SET_SOLO, FlexiCommand.LAYER_7_SET_SOLO, FlexiCommand.LAYER_8_SET_SOLO, FlexiCommand.LAYER_SELECTED_TOGGLE_SOLO, FlexiCommand.LAYER_SELECTED_SET_SOLO, FlexiCommand.LAYER_1_SET_SEND_1, FlexiCommand.LAYER_2_SET_SEND_1, FlexiCommand.LAYER_3_SET_SEND_1, FlexiCommand.LAYER_4_SET_SEND_1, FlexiCommand.LAYER_5_SET_SEND_1, FlexiCommand.LAYER_6_SET_SEND_1, FlexiCommand.LAYER_7_SET_SEND_1, FlexiCommand.LAYER_8_SET_SEND_1, FlexiCommand.LAYER_1_SET_SEND_2, FlexiCommand.LAYER_2_SET_SEND_2, FlexiCommand.LAYER_3_SET_SEND_2, FlexiCommand.LAYER_4_SET_SEND_2, FlexiCommand.LAYER_5_SET_SEND_2, FlexiCommand.LAYER_6_SET_SEND_2, FlexiCommand.LAYER_7_SET_SEND_2, FlexiCommand.LAYER_8_SET_SEND_2, FlexiCommand.LAYER_1_SET_SEND_3, FlexiCommand.LAYER_2_SET_SEND_3, FlexiCommand.LAYER_3_SET_SEND_3, FlexiCommand.LAYER_4_SET_SEND_3, FlexiCommand.LAYER_5_SET_SEND_3, FlexiCommand.LAYER_6_SET_SEND_3, FlexiCommand.LAYER_7_SET_SEND_3, FlexiCommand.LAYER_8_SET_SEND_3, FlexiCommand.LAYER_1_SET_SEND_4, FlexiCommand.LAYER_2_SET_SEND_4, FlexiCommand.LAYER_3_SET_SEND_4, FlexiCommand.LAYER_4_SET_SEND_4, FlexiCommand.LAYER_5_SET_SEND_4, FlexiCommand.LAYER_6_SET_SEND_4, FlexiCommand.LAYER_7_SET_SEND_4, FlexiCommand.LAYER_8_SET_SEND_4, FlexiCommand.LAYER_1_SET_SEND_5, FlexiCommand.LAYER_2_SET_SEND_5, FlexiCommand.LAYER_3_SET_SEND_5, FlexiCommand.LAYER_4_SET_SEND_5, FlexiCommand.LAYER_5_SET_SEND_5, FlexiCommand.LAYER_6_SET_SEND_5, FlexiCommand.LAYER_7_SET_SEND_5, FlexiCommand.LAYER_8_SET_SEND_5, FlexiCommand.LAYER_1_SET_SEND_6, FlexiCommand.LAYER_2_SET_SEND_6, FlexiCommand.LAYER_3_SET_SEND_6, FlexiCommand.LAYER_4_SET_SEND_6, FlexiCommand.LAYER_5_SET_SEND_6, FlexiCommand.LAYER_6_SET_SEND_6, FlexiCommand.LAYER_7_SET_SEND_6, FlexiCommand.LAYER_8_SET_SEND_6, FlexiCommand.LAYER_1_SET_SEND_7, FlexiCommand.LAYER_2_SET_SEND_7, FlexiCommand.LAYER_3_SET_SEND_7, FlexiCommand.LAYER_4_SET_SEND_7, FlexiCommand.LAYER_5_SET_SEND_7, FlexiCommand.LAYER_6_SET_SEND_7, FlexiCommand.LAYER_7_SET_SEND_7, FlexiCommand.LAYER_8_SET_SEND_7, FlexiCommand.LAYER_1_SET_SEND_8, FlexiCommand.LAYER_2_SET_SEND_8, FlexiCommand.LAYER_3_SET_SEND_8, FlexiCommand.LAYER_4_SET_SEND_8, FlexiCommand.LAYER_5_SET_SEND_8, FlexiCommand.LAYER_6_SET_SEND_8, FlexiCommand.LAYER_7_SET_SEND_8, FlexiCommand.LAYER_8_SET_SEND_8, FlexiCommand.LAYER_SELECTED_SET_SEND_1, FlexiCommand.LAYER_SELECTED_SET_SEND_2, FlexiCommand.LAYER_SELECTED_SET_SEND_3, FlexiCommand.LAYER_SELECTED_SET_SEND_4, FlexiCommand.LAYER_SELECTED_SET_SEND_5, FlexiCommand.LAYER_SELECTED_SET_SEND_6, FlexiCommand.LAYER_SELECTED_SET_SEND_7, FlexiCommand.LAYER_SELECTED_SET_SEND_8};
    }

    @Override
    public int getCommandValue(FlexiCommand command) {
        ILayerBank layerBank = this.getLayerBank();
        if (layerBank == null) {
            return -1;
        }
        Optional selectedLayer = layerBank.getSelectedItem();
        switch (command) {
            case LAYER_1_SELECT: 
            case LAYER_2_SELECT: 
            case LAYER_3_SELECT: 
            case LAYER_4_SELECT: 
            case LAYER_5_SELECT: 
            case LAYER_6_SELECT: 
            case LAYER_7_SELECT: 
            case LAYER_8_SELECT: {
                return LayerHandler.toMidiValue(((ILayer)layerBank.getItem(command.ordinal() - FlexiCommand.LAYER_1_SELECT.ordinal())).isSelected());
            }
            case LAYER_1_TOGGLE_ACTIVE: 
            case LAYER_2_TOGGLE_ACTIVE: 
            case LAYER_3_TOGGLE_ACTIVE: 
            case LAYER_4_TOGGLE_ACTIVE: 
            case LAYER_5_TOGGLE_ACTIVE: 
            case LAYER_6_TOGGLE_ACTIVE: 
            case LAYER_7_TOGGLE_ACTIVE: 
            case LAYER_8_TOGGLE_ACTIVE: {
                return LayerHandler.toMidiValue(((ILayer)layerBank.getItem(command.ordinal() - FlexiCommand.LAYER_1_TOGGLE_ACTIVE.ordinal())).isActivated());
            }
            case LAYER_1_SET_ACTIVE: 
            case LAYER_2_SET_ACTIVE: 
            case LAYER_3_SET_ACTIVE: 
            case LAYER_4_SET_ACTIVE: 
            case LAYER_5_SET_ACTIVE: 
            case LAYER_6_SET_ACTIVE: 
            case LAYER_7_SET_ACTIVE: 
            case LAYER_8_SET_ACTIVE: {
                return LayerHandler.toMidiValue(((ILayer)layerBank.getItem(command.ordinal() - FlexiCommand.LAYER_1_SET_ACTIVE.ordinal())).isActivated());
            }
            case LAYER_SELECTED_TOGGLE_ACTIVE: 
            case LAYER_SELECTED_SET_ACTIVE: {
                return LayerHandler.toMidiValue(selectedLayer.isPresent() && ((ILayer)selectedLayer.get()).isActivated());
            }
            case LAYER_1_SET_VOLUME: 
            case LAYER_2_SET_VOLUME: 
            case LAYER_3_SET_VOLUME: 
            case LAYER_4_SET_VOLUME: 
            case LAYER_5_SET_VOLUME: 
            case LAYER_6_SET_VOLUME: 
            case LAYER_7_SET_VOLUME: 
            case LAYER_8_SET_VOLUME: {
                return ((ILayer)layerBank.getItem(command.ordinal() - FlexiCommand.LAYER_1_SET_VOLUME.ordinal())).getVolume();
            }
            case LAYER_SELECTED_SET_VOLUME_LAYER: {
                return selectedLayer.isPresent() ? ((ILayer)selectedLayer.get()).getVolume() : 0;
            }
            case LAYER_1_SET_PANNING: 
            case LAYER_2_SET_PANNING: 
            case LAYER_3_SET_PANNING: 
            case LAYER_4_SET_PANNING: 
            case LAYER_5_SET_PANNING: 
            case LAYER_6_SET_PANNING: 
            case LAYER_7_SET_PANNING: 
            case LAYER_8_SET_PANNING: {
                return ((ILayer)layerBank.getItem(command.ordinal() - FlexiCommand.LAYER_1_SET_PANNING.ordinal())).getPan();
            }
            case LAYER_SELECTED_SET_PANNING: {
                return selectedLayer.isPresent() ? ((ILayer)selectedLayer.get()).getPan() : 0;
            }
            case LAYER_1_TOGGLE_MUTE: 
            case LAYER_2_TOGGLE_MUTE: 
            case LAYER_3_TOGGLE_MUTE: 
            case LAYER_4_TOGGLE_MUTE: 
            case LAYER_5_TOGGLE_MUTE: 
            case LAYER_6_TOGGLE_MUTE: 
            case LAYER_7_TOGGLE_MUTE: 
            case LAYER_8_TOGGLE_MUTE: {
                return LayerHandler.toMidiValue(((ILayer)layerBank.getItem(command.ordinal() - FlexiCommand.LAYER_1_TOGGLE_MUTE.ordinal())).isMute());
            }
            case LAYER_1_SET_MUTE: 
            case LAYER_2_SET_MUTE: 
            case LAYER_3_SET_MUTE: 
            case LAYER_4_SET_MUTE: 
            case LAYER_5_SET_MUTE: 
            case LAYER_6_SET_MUTE: 
            case LAYER_7_SET_MUTE: 
            case LAYER_8_SET_MUTE: {
                return LayerHandler.toMidiValue(((ILayer)layerBank.getItem(command.ordinal() - FlexiCommand.LAYER_1_SET_MUTE.ordinal())).isMute());
            }
            case LAYER_SELECTED_TOGGLE_MUTE: 
            case LAYER_SELECTED_SET_MUTE: {
                return LayerHandler.toMidiValue(selectedLayer.isPresent() && ((ILayer)selectedLayer.get()).isMute());
            }
            case LAYER_1_TOGGLE_SOLO: 
            case LAYER_2_TOGGLE_SOLO: 
            case LAYER_3_TOGGLE_SOLO: 
            case LAYER_4_TOGGLE_SOLO: 
            case LAYER_5_TOGGLE_SOLO: 
            case LAYER_6_TOGGLE_SOLO: 
            case LAYER_7_TOGGLE_SOLO: 
            case LAYER_8_TOGGLE_SOLO: {
                return LayerHandler.toMidiValue(((ILayer)layerBank.getItem(command.ordinal() - FlexiCommand.LAYER_1_TOGGLE_SOLO.ordinal())).isSolo());
            }
            case LAYER_1_SET_SOLO: 
            case LAYER_2_SET_SOLO: 
            case LAYER_3_SET_SOLO: 
            case LAYER_4_SET_SOLO: 
            case LAYER_5_SET_SOLO: 
            case LAYER_6_SET_SOLO: 
            case LAYER_7_SET_SOLO: 
            case LAYER_8_SET_SOLO: {
                return LayerHandler.toMidiValue(((ILayer)layerBank.getItem(command.ordinal() - FlexiCommand.LAYER_1_SET_SOLO.ordinal())).isSolo());
            }
            case LAYER_SELECTED_TOGGLE_SOLO: 
            case LAYER_SELECTED_SET_SOLO: {
                return LayerHandler.toMidiValue(selectedLayer.isPresent() && ((ILayer)selectedLayer.get()).isSolo());
            }
            case LAYER_1_SET_SEND_1: 
            case LAYER_2_SET_SEND_1: 
            case LAYER_3_SET_SEND_1: 
            case LAYER_4_SET_SEND_1: 
            case LAYER_5_SET_SEND_1: 
            case LAYER_6_SET_SEND_1: 
            case LAYER_7_SET_SEND_1: 
            case LAYER_8_SET_SEND_1: {
                return this.getSendValue(command.ordinal() - FlexiCommand.LAYER_1_SET_SEND_1.ordinal(), 0);
            }
            case LAYER_1_SET_SEND_2: 
            case LAYER_2_SET_SEND_2: 
            case LAYER_3_SET_SEND_2: 
            case LAYER_4_SET_SEND_2: 
            case LAYER_5_SET_SEND_2: 
            case LAYER_6_SET_SEND_2: 
            case LAYER_7_SET_SEND_2: 
            case LAYER_8_SET_SEND_2: {
                return this.getSendValue(command.ordinal() - FlexiCommand.LAYER_1_SET_SEND_2.ordinal(), 1);
            }
            case LAYER_1_SET_SEND_3: 
            case LAYER_2_SET_SEND_3: 
            case LAYER_3_SET_SEND_3: 
            case LAYER_4_SET_SEND_3: 
            case LAYER_5_SET_SEND_3: 
            case LAYER_6_SET_SEND_3: 
            case LAYER_7_SET_SEND_3: 
            case LAYER_8_SET_SEND_3: {
                return this.getSendValue(command.ordinal() - FlexiCommand.LAYER_1_SET_SEND_3.ordinal(), 2);
            }
            case LAYER_1_SET_SEND_4: 
            case LAYER_2_SET_SEND_4: 
            case LAYER_3_SET_SEND_4: 
            case LAYER_4_SET_SEND_4: 
            case LAYER_5_SET_SEND_4: 
            case LAYER_6_SET_SEND_4: 
            case LAYER_7_SET_SEND_4: 
            case LAYER_8_SET_SEND_4: {
                return this.getSendValue(command.ordinal() - FlexiCommand.LAYER_1_SET_SEND_4.ordinal(), 3);
            }
            case LAYER_1_SET_SEND_5: 
            case LAYER_2_SET_SEND_5: 
            case LAYER_3_SET_SEND_5: 
            case LAYER_4_SET_SEND_5: 
            case LAYER_5_SET_SEND_5: 
            case LAYER_6_SET_SEND_5: 
            case LAYER_7_SET_SEND_5: 
            case LAYER_8_SET_SEND_5: {
                return this.getSendValue(command.ordinal() - FlexiCommand.LAYER_1_SET_SEND_5.ordinal(), 4);
            }
            case LAYER_1_SET_SEND_6: 
            case LAYER_2_SET_SEND_6: 
            case LAYER_3_SET_SEND_6: 
            case LAYER_4_SET_SEND_6: 
            case LAYER_5_SET_SEND_6: 
            case LAYER_6_SET_SEND_6: 
            case LAYER_7_SET_SEND_6: 
            case LAYER_8_SET_SEND_6: {
                return this.getSendValue(command.ordinal() - FlexiCommand.LAYER_1_SET_SEND_6.ordinal(), 5);
            }
            case LAYER_1_SET_SEND_7: 
            case LAYER_2_SET_SEND_7: 
            case LAYER_3_SET_SEND_7: 
            case LAYER_4_SET_SEND_7: 
            case LAYER_5_SET_SEND_7: 
            case LAYER_6_SET_SEND_7: 
            case LAYER_7_SET_SEND_7: 
            case LAYER_8_SET_SEND_7: {
                return this.getSendValue(command.ordinal() - FlexiCommand.LAYER_1_SET_SEND_7.ordinal(), 6);
            }
            case LAYER_1_SET_SEND_8: 
            case LAYER_2_SET_SEND_8: 
            case LAYER_3_SET_SEND_8: 
            case LAYER_4_SET_SEND_8: 
            case LAYER_5_SET_SEND_8: 
            case LAYER_6_SET_SEND_8: 
            case LAYER_7_SET_SEND_8: 
            case LAYER_8_SET_SEND_8: {
                return this.getSendValue(command.ordinal() - FlexiCommand.LAYER_1_SET_SEND_8.ordinal(), 7);
            }
            case LAYER_SELECTED_SET_SEND_1: 
            case LAYER_SELECTED_SET_SEND_2: 
            case LAYER_SELECTED_SET_SEND_3: 
            case LAYER_SELECTED_SET_SEND_4: 
            case LAYER_SELECTED_SET_SEND_5: 
            case LAYER_SELECTED_SET_SEND_6: 
            case LAYER_SELECTED_SET_SEND_7: 
            case LAYER_SELECTED_SET_SEND_8: {
                return this.getSendValue(-1, command.ordinal() - FlexiCommand.LAYER_SELECTED_SET_SEND_1.ordinal());
            }
        }
        return -1;
    }

    @Override
    public void handle(FlexiCommand command, KnobMode knobMode, MidiValue value) {
        ILayerBank layerBank = this.getLayerBank();
        if (layerBank == null) {
            return;
        }
        Optional selectedLayer = layerBank.getSelectedItem();
        boolean isButtonPressed = this.isButtonPressed(knobMode, value);
        switch (command) {
            case LAYER_SELECT_PREVIOUS_BANK_PAGE: {
                if (!isButtonPressed) break;
                this.scrollLayerLeft(true);
                break;
            }
            case LAYER_SELECT_NEXT_BANK_PAGE: {
                if (!isButtonPressed) break;
                this.scrollLayerRight(true);
                break;
            }
            case LAYER_SELECT_PREVIOUS_LAYER: {
                if (!isButtonPressed) break;
                this.scrollLayerLeft(false);
                break;
            }
            case LAYER_SELECT_NEXT_LAYER: {
                if (!isButtonPressed) break;
                this.scrollLayerRight(false);
                break;
            }
            case LAYER_SCROLL_LAYERS: {
                this.scrollLayer(knobMode, value);
                break;
            }
            case LAYER_1_SELECT: 
            case LAYER_2_SELECT: 
            case LAYER_3_SELECT: 
            case LAYER_4_SELECT: 
            case LAYER_5_SELECT: 
            case LAYER_6_SELECT: 
            case LAYER_7_SELECT: 
            case LAYER_8_SELECT: {
                if (!isButtonPressed) break;
                ((ILayer)layerBank.getItem(command.ordinal() - FlexiCommand.LAYER_1_SELECT.ordinal())).select();
                this.mvHelper.notifySelectedLayer();
                break;
            }
            case LAYER_1_TOGGLE_ACTIVE: 
            case LAYER_2_TOGGLE_ACTIVE: 
            case LAYER_3_TOGGLE_ACTIVE: 
            case LAYER_4_TOGGLE_ACTIVE: 
            case LAYER_5_TOGGLE_ACTIVE: 
            case LAYER_6_TOGGLE_ACTIVE: 
            case LAYER_7_TOGGLE_ACTIVE: 
            case LAYER_8_TOGGLE_ACTIVE: {
                if (!isButtonPressed) break;
                ((ILayer)layerBank.getItem(command.ordinal() - FlexiCommand.LAYER_1_TOGGLE_ACTIVE.ordinal())).toggleIsActivated();
                break;
            }
            case LAYER_1_SET_ACTIVE: 
            case LAYER_2_SET_ACTIVE: 
            case LAYER_3_SET_ACTIVE: 
            case LAYER_4_SET_ACTIVE: 
            case LAYER_5_SET_ACTIVE: 
            case LAYER_6_SET_ACTIVE: 
            case LAYER_7_SET_ACTIVE: 
            case LAYER_8_SET_ACTIVE: {
                if (!isButtonPressed) break;
                ((ILayer)layerBank.getItem(command.ordinal() - FlexiCommand.LAYER_1_SET_ACTIVE.ordinal())).setIsActivated(value.isPositive());
                break;
            }
            case LAYER_SELECTED_TOGGLE_ACTIVE: {
                if (!isButtonPressed || !selectedLayer.isPresent()) break;
                ((ILayer)selectedLayer.get()).toggleIsActivated();
                break;
            }
            case LAYER_SELECTED_SET_ACTIVE: {
                if (!isButtonPressed || !selectedLayer.isPresent()) break;
                ((ILayer)selectedLayer.get()).setIsActivated(value.isPositive());
                break;
            }
            case LAYER_1_SET_VOLUME: 
            case LAYER_2_SET_VOLUME: 
            case LAYER_3_SET_VOLUME: 
            case LAYER_4_SET_VOLUME: 
            case LAYER_5_SET_VOLUME: 
            case LAYER_6_SET_VOLUME: 
            case LAYER_7_SET_VOLUME: 
            case LAYER_8_SET_VOLUME: {
                this.changeLayerVolume(knobMode, command.ordinal() - FlexiCommand.LAYER_1_SET_VOLUME.ordinal(), value);
                break;
            }
            case LAYER_SELECTED_SET_VOLUME_LAYER: {
                this.changeLayerVolume(knobMode, -1, value);
                break;
            }
            case LAYER_1_SET_PANNING: 
            case LAYER_2_SET_PANNING: 
            case LAYER_3_SET_PANNING: 
            case LAYER_4_SET_PANNING: 
            case LAYER_5_SET_PANNING: 
            case LAYER_6_SET_PANNING: 
            case LAYER_7_SET_PANNING: 
            case LAYER_8_SET_PANNING: {
                this.changeLayerPanning(knobMode, command.ordinal() - FlexiCommand.LAYER_1_SET_PANNING.ordinal(), value);
                break;
            }
            case LAYER_SELECTED_SET_PANNING: {
                this.changeLayerPanning(knobMode, -1, value);
                break;
            }
            case LAYER_1_TOGGLE_MUTE: 
            case LAYER_2_TOGGLE_MUTE: 
            case LAYER_3_TOGGLE_MUTE: 
            case LAYER_4_TOGGLE_MUTE: 
            case LAYER_5_TOGGLE_MUTE: 
            case LAYER_6_TOGGLE_MUTE: 
            case LAYER_7_TOGGLE_MUTE: 
            case LAYER_8_TOGGLE_MUTE: {
                if (!isButtonPressed) break;
                ((ILayer)layerBank.getItem(command.ordinal() - FlexiCommand.LAYER_1_TOGGLE_MUTE.ordinal())).toggleMute();
                break;
            }
            case LAYER_1_SET_MUTE: 
            case LAYER_2_SET_MUTE: 
            case LAYER_3_SET_MUTE: 
            case LAYER_4_SET_MUTE: 
            case LAYER_5_SET_MUTE: 
            case LAYER_6_SET_MUTE: 
            case LAYER_7_SET_MUTE: 
            case LAYER_8_SET_MUTE: {
                if (!isButtonPressed) break;
                ((ILayer)layerBank.getItem(command.ordinal() - FlexiCommand.LAYER_1_SET_MUTE.ordinal())).setMute(value.isPositive());
                break;
            }
            case LAYER_SELECTED_TOGGLE_MUTE: {
                if (!isButtonPressed || !selectedLayer.isPresent()) break;
                ((ILayer)selectedLayer.get()).toggleMute();
                break;
            }
            case LAYER_SELECTED_SET_MUTE: {
                if (!isButtonPressed || !selectedLayer.isPresent()) break;
                ((ILayer)selectedLayer.get()).setMute(value.isPositive());
                break;
            }
            case LAYER_1_TOGGLE_SOLO: 
            case LAYER_2_TOGGLE_SOLO: 
            case LAYER_3_TOGGLE_SOLO: 
            case LAYER_4_TOGGLE_SOLO: 
            case LAYER_5_TOGGLE_SOLO: 
            case LAYER_6_TOGGLE_SOLO: 
            case LAYER_7_TOGGLE_SOLO: 
            case LAYER_8_TOGGLE_SOLO: {
                if (!isButtonPressed) break;
                ((ILayer)layerBank.getItem(command.ordinal() - FlexiCommand.LAYER_1_TOGGLE_SOLO.ordinal())).toggleSolo();
                break;
            }
            case LAYER_1_SET_SOLO: 
            case LAYER_2_SET_SOLO: 
            case LAYER_3_SET_SOLO: 
            case LAYER_4_SET_SOLO: 
            case LAYER_5_SET_SOLO: 
            case LAYER_6_SET_SOLO: 
            case LAYER_7_SET_SOLO: 
            case LAYER_8_SET_SOLO: {
                if (!isButtonPressed) break;
                ((ILayer)layerBank.getItem(command.ordinal() - FlexiCommand.LAYER_1_SET_SOLO.ordinal())).setSolo(value.isPositive());
                break;
            }
            case LAYER_SELECTED_TOGGLE_SOLO: {
                if (!isButtonPressed || !selectedLayer.isPresent()) break;
                ((ILayer)selectedLayer.get()).toggleSolo();
                break;
            }
            case LAYER_SELECTED_SET_SOLO: {
                if (!isButtonPressed || !selectedLayer.isPresent()) break;
                ((ILayer)selectedLayer.get()).setSolo(value.isPositive());
                break;
            }
            case LAYER_1_SET_SEND_1: 
            case LAYER_2_SET_SEND_1: 
            case LAYER_3_SET_SEND_1: 
            case LAYER_4_SET_SEND_1: 
            case LAYER_5_SET_SEND_1: 
            case LAYER_6_SET_SEND_1: 
            case LAYER_7_SET_SEND_1: 
            case LAYER_8_SET_SEND_1: {
                this.changeSendVolume(command.ordinal() - FlexiCommand.LAYER_1_SET_SEND_1.ordinal(), 0, knobMode, value);
                break;
            }
            case LAYER_1_SET_SEND_2: 
            case LAYER_2_SET_SEND_2: 
            case LAYER_3_SET_SEND_2: 
            case LAYER_4_SET_SEND_2: 
            case LAYER_5_SET_SEND_2: 
            case LAYER_6_SET_SEND_2: 
            case LAYER_7_SET_SEND_2: 
            case LAYER_8_SET_SEND_2: {
                this.changeSendVolume(command.ordinal() - FlexiCommand.LAYER_1_SET_SEND_2.ordinal(), 1, knobMode, value);
                break;
            }
            case LAYER_1_SET_SEND_3: 
            case LAYER_2_SET_SEND_3: 
            case LAYER_3_SET_SEND_3: 
            case LAYER_4_SET_SEND_3: 
            case LAYER_5_SET_SEND_3: 
            case LAYER_6_SET_SEND_3: 
            case LAYER_7_SET_SEND_3: 
            case LAYER_8_SET_SEND_3: {
                this.changeSendVolume(command.ordinal() - FlexiCommand.LAYER_1_SET_SEND_3.ordinal(), 2, knobMode, value);
                break;
            }
            case LAYER_1_SET_SEND_4: 
            case LAYER_2_SET_SEND_4: 
            case LAYER_3_SET_SEND_4: 
            case LAYER_4_SET_SEND_4: 
            case LAYER_5_SET_SEND_4: 
            case LAYER_6_SET_SEND_4: 
            case LAYER_7_SET_SEND_4: 
            case LAYER_8_SET_SEND_4: {
                this.changeSendVolume(command.ordinal() - FlexiCommand.LAYER_1_SET_SEND_4.ordinal(), 3, knobMode, value);
                break;
            }
            case LAYER_1_SET_SEND_5: 
            case LAYER_2_SET_SEND_5: 
            case LAYER_3_SET_SEND_5: 
            case LAYER_4_SET_SEND_5: 
            case LAYER_5_SET_SEND_5: 
            case LAYER_6_SET_SEND_5: 
            case LAYER_7_SET_SEND_5: 
            case LAYER_8_SET_SEND_5: {
                this.changeSendVolume(command.ordinal() - FlexiCommand.LAYER_1_SET_SEND_5.ordinal(), 4, knobMode, value);
                break;
            }
            case LAYER_1_SET_SEND_6: 
            case LAYER_2_SET_SEND_6: 
            case LAYER_3_SET_SEND_6: 
            case LAYER_4_SET_SEND_6: 
            case LAYER_5_SET_SEND_6: 
            case LAYER_6_SET_SEND_6: 
            case LAYER_7_SET_SEND_6: 
            case LAYER_8_SET_SEND_6: {
                this.changeSendVolume(command.ordinal() - FlexiCommand.LAYER_1_SET_SEND_6.ordinal(), 5, knobMode, value);
                break;
            }
            case LAYER_1_SET_SEND_7: 
            case LAYER_2_SET_SEND_7: 
            case LAYER_3_SET_SEND_7: 
            case LAYER_4_SET_SEND_7: 
            case LAYER_5_SET_SEND_7: 
            case LAYER_6_SET_SEND_7: 
            case LAYER_7_SET_SEND_7: 
            case LAYER_8_SET_SEND_7: {
                this.changeSendVolume(command.ordinal() - FlexiCommand.LAYER_1_SET_SEND_7.ordinal(), 6, knobMode, value);
                break;
            }
            case LAYER_1_SET_SEND_8: 
            case LAYER_2_SET_SEND_8: 
            case LAYER_3_SET_SEND_8: 
            case LAYER_4_SET_SEND_8: 
            case LAYER_5_SET_SEND_8: 
            case LAYER_6_SET_SEND_8: 
            case LAYER_7_SET_SEND_8: 
            case LAYER_8_SET_SEND_8: {
                this.changeSendVolume(command.ordinal() - FlexiCommand.LAYER_1_SET_SEND_8.ordinal(), 7, knobMode, value);
                break;
            }
            case LAYER_SELECTED_SET_SEND_1: 
            case LAYER_SELECTED_SET_SEND_2: 
            case LAYER_SELECTED_SET_SEND_3: 
            case LAYER_SELECTED_SET_SEND_4: 
            case LAYER_SELECTED_SET_SEND_5: 
            case LAYER_SELECTED_SET_SEND_6: 
            case LAYER_SELECTED_SET_SEND_7: 
            case LAYER_SELECTED_SET_SEND_8: {
                this.changeSendVolume(-1, command.ordinal() - FlexiCommand.LAYER_SELECTED_SET_SEND_1.ordinal(), knobMode, value);
                break;
            }
            default: {
                throw new FlexiHandlerException(command);
            }
        }
    }

    private int getSendValue(int layerIndex, int sendIndex) {
        Optional<ILayer> layer = this.getLayer(layerIndex);
        if (layer.isEmpty()) {
            return 0;
        }
        ISendBank sendBank = layer.get().getSendBank();
        if (sendIndex >= sendBank.getPageSize()) {
            return 0;
        }
        ISend send = (ISend)sendBank.getItem(sendIndex);
        if (send == null) {
            return 0;
        }
        return send.getValue();
    }

    private Optional<ILayer> getLayer(int layerIndex) {
        ILayerBank layerBank = this.getLayerBank();
        if (layerBank == null) {
            return Optional.empty();
        }
        if (layerIndex < 0) {
            return layerBank.getSelectedItem();
        }
        ILayer item = (ILayer)layerBank.getItem(layerIndex);
        return item.doesExist() ? Optional.of(item) : Optional.empty();
    }

    private void changeLayerVolume(KnobMode knobMode, int layerIndex, MidiValue value) {
        Optional<ILayer> layer = this.getLayer(layerIndex);
        if (layer.isEmpty()) {
            return;
        }
        int val = value.getValue();
        IParameter volumeParameter = layer.get().getVolumeParameter();
        if (LayerHandler.isAbsolute(knobMode)) {
            volumeParameter.setValue(this.getAbsoluteValueChanger(value), val);
        } else {
            volumeParameter.changeValue(this.getRelativeValueChanger(knobMode), val);
        }
    }

    private void changeLayerPanning(KnobMode knobMode, int layerIndex, MidiValue value) {
        Optional<ILayer> layer = this.getLayer(layerIndex);
        if (layer.isEmpty()) {
            return;
        }
        int val = value.getValue();
        IParameter panParameter = layer.get().getPanParameter();
        if (LayerHandler.isAbsolute(knobMode)) {
            panParameter.setValue(this.getAbsoluteValueChanger(value), val);
        } else {
            panParameter.changeValue(this.getRelativeValueChanger(knobMode), val);
        }
    }

    private void changeSendVolume(int layerIndex, int sendIndex, KnobMode knobMode, MidiValue value) {
        Optional<ILayer> layer = this.getLayer(layerIndex);
        if (layer.isEmpty()) {
            return;
        }
        ISendBank sendBank = layer.get().getSendBank();
        if (sendIndex >= sendBank.getPageSize()) {
            return;
        }
        ISend send = (ISend)sendBank.getItem(sendIndex);
        if (send == null) {
            return;
        }
        int val = value.getValue();
        if (LayerHandler.isAbsolute(knobMode)) {
            send.setValue(this.getAbsoluteValueChanger(value), val);
        } else {
            send.changeValue(this.getRelativeValueChanger(knobMode), val);
        }
    }

    private void scrollLayer(KnobMode knobMode, MidiValue value) {
        if (LayerHandler.isAbsolute(knobMode) || !this.increaseKnobMovement()) {
            return;
        }
        if (this.isIncrease(knobMode, value)) {
            this.scrollLayerRight(false);
        } else {
            this.scrollLayerLeft(false);
        }
    }

    private void scrollLayerLeft(boolean switchBank) {
        int index;
        ILayerBank layerBank = this.getLayerBank();
        if (layerBank == null) {
            return;
        }
        Optional sel = layerBank.getSelectedItem();
        int n = index = sel.isEmpty() ? 0 : ((ILayer)sel.get()).getIndex() - 1;
        if (index == -1 || switchBank) {
            layerBank.selectPreviousPage();
            return;
        }
        ((ILayer)layerBank.getItem(index)).select();
    }

    private void scrollLayerRight(boolean switchBank) {
        int index;
        ILayerBank layerBank = this.getLayerBank();
        if (layerBank == null) {
            return;
        }
        Optional sel = layerBank.getSelectedItem();
        int n = index = sel.isEmpty() ? 0 : ((ILayer)sel.get()).getIndex() + 1;
        if (index == 8 || switchBank) {
            layerBank.selectNextPage();
            return;
        }
        ((ILayer)layerBank.getItem(index)).select();
    }

    private ILayerBank getLayerBank() {
        ICursorDevice cursorDevice = this.model.getCursorDevice();
        return cursorDevice.hasLayers() ? cursorDevice.getLayerBank() : null;
    }
}

