/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.faderfox.ec4.mode;

import de.mossgrabers.controller.faderfox.ec4.controller.EC4ControlSurface;
import de.mossgrabers.controller.faderfox.ec4.mode.AbstractEC4Mode;
import de.mossgrabers.framework.controller.display.ITextDisplay;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ISend;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.ISendBank;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import de.mossgrabers.framework.parameterprovider.IParameterProvider;
import de.mossgrabers.framework.parameterprovider.special.CombinedParameterProvider;
import de.mossgrabers.framework.parameterprovider.track.MuteParameterProvider;
import de.mossgrabers.framework.parameterprovider.track.PanParameterProvider;
import de.mossgrabers.framework.parameterprovider.track.SendParameterProvider;
import de.mossgrabers.framework.parameterprovider.track.SoloParameterProvider;
import de.mossgrabers.framework.parameterprovider.track.VolumeParameterProvider;
import de.mossgrabers.framework.utils.ButtonEvent;
import java.util.ArrayList;

public class EC4TwelveMode
extends AbstractEC4Mode<ITrack> {
    private static final String[] SUB_MODES = new String[]{"Mn V", "Mn P", "Mn M", "Mn S", "MnS1", "MnS2", "MnS3", "MnS4", "MnS5", "MnS6", "MnS7", "MnS8"};
    private final IParameterProvider[] providers = new IParameterProvider[12];
    private int selectedParam = 0;

    public EC4TwelveMode(EC4ControlSurface surface, IModel model) {
        super("Volume", surface, model, model.getTrackBank());
        this.providers[0] = new CombinedParameterProvider(new VolumeParameterProvider(model), this.bottomRowProvider);
        this.providers[1] = new CombinedParameterProvider(new PanParameterProvider(model), this.bottomRowProvider);
        this.providers[2] = new CombinedParameterProvider(new MuteParameterProvider(model), this.bottomRowProvider);
        this.providers[3] = new CombinedParameterProvider(new SoloParameterProvider(model), this.bottomRowProvider);
        for (int i = 0; i < 8; ++i) {
            this.providers[4 + i] = new CombinedParameterProvider(new SendParameterProvider(model, i, 0), this.bottomRowProvider);
        }
        this.setParameterProvider(this.providers[0]);
    }

    @Override
    public void onButton(int row, int column, ButtonEvent event) {
        if (!this.isSession && row < 3) {
            if (event == ButtonEvent.DOWN) {
                if (((EC4ControlSurface)this.surface).isShiftPressed()) {
                    ITrack track = (ITrack)this.model.getTrackBank().getItem(row * 4 + column);
                    switch (this.selectedParam) {
                        case 0: {
                            track.resetVolume();
                            break;
                        }
                        case 1: {
                            track.resetPan();
                            break;
                        }
                        case 2: {
                            track.setMute(false);
                            break;
                        }
                        case 3: {
                            track.setSolo(false);
                            break;
                        }
                        default: {
                            ((ISend)track.getSendBank().getItem(this.selectedParam - 4)).resetValue();
                        }
                    }
                    return;
                }
                this.selectedParam = row * 4 + column;
                this.setParameterProvider(this.providers[this.selectedParam]);
                this.bindControls();
            }
            return;
        }
        super.onButton(row, column, event);
    }

    @Override
    public void updateDisplay() {
        ArrayList<String[]> totalDisplayInfo = new ArrayList<String[]>();
        ITextDisplay display = ((EC4ControlSurface)this.surface).getTextDisplay().clear();
        ITrackBank trackBank = this.model.getTrackBank();
        for (int i = 0; i < 12; ++i) {
            ITrack track = (ITrack)trackBank.getItem(i);
            ISendBank sendBank = track.getSendBank();
            String trackName = track.getPosition() + 1 + ": " + track.getName();
            Object text = "    ";
            if (!track.doesExist()) continue;
            switch (this.selectedParam) {
                case 0: {
                    text = track.getVolumeStr(4);
                    this.updateCache(i, track.getVolume(), totalDisplayInfo, trackName, "", "Volume: " + track.getVolumeStr());
                    break;
                }
                case 1: {
                    text = track.getPanStr(4);
                    this.updateCache(i, track.getPan(), totalDisplayInfo, trackName, "", "Pan: " + track.getPanStr());
                    break;
                }
                case 2: {
                    text = track.isMute() ? "Mute" : "   ";
                    this.updateCache(i, track.isMute() ? 127 : 0, totalDisplayInfo, trackName, "", "Mute: " + (track.isMute() ? "on" : "off"));
                    break;
                }
                case 3: {
                    text = track.isSolo() ? "Solo" : "   ";
                    this.updateCache(i, track.isSolo() ? 127 : 0, totalDisplayInfo, trackName, "", "Solo: " + (track.isSolo() ? "on" : "off"));
                    break;
                }
                default: {
                    ISend send = (ISend)sendBank.getItem(this.selectedParam - 4);
                    if (!send.doesExist()) break;
                    text = send.getDisplayedValue(4);
                    this.updateCache(i, send.getValue(), totalDisplayInfo, trackName, "", i + 1 + ": " + send.getName(7) + ": " + send.getDisplayedValue());
                }
            }
            if (((String)text).endsWith(".")) {
                text = ((String)text).substring(0, 3);
            }
            if (((String)text).length() == 3) {
                text = " " + (String)text;
            }
            display.setCell(i / 4, i % 4, (String)text);
        }
        super.updateDisplayRow4(display, totalDisplayInfo, SUB_MODES[this.selectedParam]);
        display.allDone();
        ((EC4ControlSurface)this.surface).fillTotalDisplay(totalDisplayInfo);
    }
}

