/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.arturia.beatstep.view;

import de.mossgrabers.controller.arturia.beatstep.controller.BeatstepControlSurface;
import de.mossgrabers.controller.arturia.beatstep.view.BaseSequencerView;
import de.mossgrabers.framework.controller.grid.IPadGrid;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.clip.INoteClip;
import de.mossgrabers.framework.daw.clip.NotePosition;
import de.mossgrabers.framework.daw.clip.StepState;
import de.mossgrabers.framework.daw.constants.Resolution;
import de.mossgrabers.framework.daw.data.IDrumDevice;
import de.mossgrabers.framework.daw.data.IDrumPad;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.IDrumPadBank;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import java.util.Optional;

public class DrumView
extends BaseSequencerView {
    private static final int NUM_DISPLAY_COLS = 16;

    public DrumView(BeatstepControlSurface surface, IModel model) {
        super("Drum", surface, model, 128, 16);
        ITrackBank tb = model.getTrackBank();
        tb.addSelectionObserver((index, isSelected) -> this.keyManager.clearPressedKeys());
        tb.addNoteObserver(this::updateNote);
    }

    @Override
    public void onKnob(int index, int value) {
        boolean isIncrease = this.model.getValueChanger().isIncrease(value);
        switch (index) {
            case 12: {
                this.changeScrollPosition(isIncrease);
                break;
            }
            case 13: {
                this.changeResolution(value);
                ((BeatstepControlSurface)this.surface).getDisplay().notify(Resolution.getNameAt(this.getResolutionIndex()));
                break;
            }
            case 14: {
                this.keyManager.clearPressedKeys();
                if (isIncrease) {
                    this.scales.incDrumOctave();
                    this.model.getDrumDevice().getDrumPadBank().selectNextPage();
                } else {
                    this.scales.decDrumOctave();
                    this.model.getDrumDevice().getDrumPadBank().selectPreviousPage();
                }
                this.updateNoteMapping();
                ((BeatstepControlSurface)this.surface).getDisplay().notify(this.scales.getDrumRangeText());
                break;
            }
            case 15: {
                this.isPlayMode = !isIncrease;
                ((BeatstepControlSurface)this.surface).getDisplay().notify(this.isPlayMode ? "Play/Select" : "Sequence");
                this.updateNoteMapping();
                break;
            }
            default: {
                this.extensions.onTrackKnob(index, value);
            }
        }
    }

    @Override
    public void onGridNote(int note, int velocity) {
        if (!this.model.canSelectedTrackHoldNotes()) {
            return;
        }
        int index = note - 36;
        int offsetY = this.scales.getDrumOffset();
        if (this.isPlayMode) {
            this.selectedPad = index;
            this.keyManager.setKeyPressed(offsetY + this.selectedPad, velocity);
        } else if (velocity != 0) {
            NotePosition notePosition = new NotePosition(this.configuration.getMidiEditChannel(), index < 8 ? index + 8 : index - 8, offsetY + this.selectedPad);
            this.getClip().toggleStep(notePosition, this.configuration.isAccentActive() ? this.configuration.getFixedAccentValue() : velocity);
        }
    }

    @Override
    public void updateNoteMapping() {
        this.delayedUpdateNoteMapping(this.model.canSelectedTrackHoldNotes() && this.isPlayMode ? this.scales.getDrumMatrix() : EMPTY_TABLE);
    }

    @Override
    public void drawGrid() {
        IPadGrid padGrid = ((BeatstepControlSurface)this.surface).getPadGrid();
        if (!this.model.canSelectedTrackHoldNotes()) {
            padGrid.turnOff();
            return;
        }
        if (this.isPlayMode) {
            IDrumDevice primary = this.model.getDrumDevice();
            for (int y = 0; y < 2; ++y) {
                for (int x = 0; x < 8; ++x) {
                    int index = 8 * y + x;
                    padGrid.lightEx(x, y, this.getDrumPadColor(index, primary));
                }
            }
            return;
        }
        INoteClip clip = this.getClip();
        int step = clip.getCurrentStep();
        int hiStep = this.isInXRange(step) ? step % 16 : -1;
        int offsetY = this.scales.getDrumOffset();
        NotePosition notePosition = new NotePosition(this.configuration.getMidiEditChannel(), 0, offsetY + this.selectedPad);
        for (int col = 0; col < 16; ++col) {
            notePosition.setStep(col);
            StepState stepState = clip.getStep(notePosition).getState();
            boolean hilite = col == hiStep;
            int x = col % 8;
            int y = col / 8;
            padGrid.lightEx(x, 1 - y, DrumView.getSequencerPadColor(stepState, hilite));
        }
    }

    private static int getSequencerPadColor(StepState stepState, boolean hilite) {
        if (stepState != StepState.OFF) {
            return hilite ? 17 : 16;
        }
        return hilite ? 17 : 0;
    }

    private int getDrumPadColor(int index, IDrumDevice primary) {
        int offsetY = this.scales.getDrumOffset();
        if (this.keyManager.isKeyPressed(offsetY + index)) {
            return 17;
        }
        if (this.selectedPad == index) {
            return 1;
        }
        IDrumPadBank drumPadBank = primary.getDrumPadBank();
        IDrumPad drumPad = drumPadBank.getItem(index);
        if (!drumPad.doesExist() || !drumPad.isActivated()) {
            return 0;
        }
        if (drumPad.isMute() || drumPadBank.hasSoloedPads() && !drumPad.isSolo()) {
            return 0;
        }
        return 16;
    }

    private void updateNote(int trackIndex, int note, int velocity) {
        Optional sel = this.model.getCurrentTrackBank().getSelectedItem();
        if (sel.isPresent() && ((ITrack)sel.get()).getIndex() == trackIndex) {
            this.keyManager.setKeyPressed(note, velocity);
        }
    }
}

