/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.akai.fire.view;

import de.mossgrabers.controller.akai.fire.FireConfiguration;
import de.mossgrabers.controller.akai.fire.controller.FireControlSurface;
import de.mossgrabers.controller.akai.fire.controller.FirePadGrid;
import de.mossgrabers.controller.akai.fire.view.IFireView;
import de.mossgrabers.framework.configuration.AbstractConfiguration;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.daw.DAWColor;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.ITransport;
import de.mossgrabers.framework.daw.clip.INoteClip;
import de.mossgrabers.framework.daw.constants.AutomationMode;
import de.mossgrabers.framework.daw.constants.Capability;
import de.mossgrabers.framework.daw.constants.Resolution;
import de.mossgrabers.framework.daw.midi.ArpeggiatorMode;
import de.mossgrabers.framework.daw.midi.INoteRepeat;
import de.mossgrabers.framework.daw.resource.ChannelType;
import de.mossgrabers.framework.featuregroup.IView;
import de.mossgrabers.framework.featuregroup.ViewManager;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.AbstractShiftView;
import de.mossgrabers.framework.view.Views;

public class ShiftView
extends AbstractShiftView<FireControlSurface, FireConfiguration>
implements IFireView {
    public ShiftView(FireControlSurface surface, IModel model) {
        super("Shift", surface, model);
    }

    @Override
    public void drawGrid() {
        int i;
        FirePadGrid padGrid = ((FireControlSurface)this.surface).getPadGrid();
        IHost host = this.model.getHost();
        INoteRepeat noteRepeat = ((FireControlSurface)this.surface).getMidiInput().getDefaultNoteInput().getNoteRepeat();
        padGrid.light(84, DAWColor.getColorID((noteRepeat.isActive() ? DAWColor.DAW_COLOR_GREEN : DAWColor.DAW_COLOR_GRAY).getColor()));
        if (host.supports(Capability.NOTE_REPEAT_OCTAVES)) {
            int octaves = noteRepeat.getOctaves();
            for (int i2 = 0; i2 < 4; ++i2) {
                padGrid.light(36 + i2, DAWColor.getColorID((octaves == i2 ? DAWColor.DAW_COLOR_GREEN : DAWColor.DAW_COLOR_GRAY).getColor()));
                padGrid.light(52 + i2, DAWColor.getColorID((octaves == 4 + i2 ? DAWColor.DAW_COLOR_GREEN : DAWColor.DAW_COLOR_GRAY).getColor()));
            }
            padGrid.light(68, DAWColor.getColorID((octaves == 8 ? DAWColor.DAW_COLOR_GREEN : DAWColor.DAW_COLOR_GRAY).getColor()));
        } else {
            for (int i3 = 0; i3 < 4; ++i3) {
                padGrid.light(36 + i3, 0);
                padGrid.light(52 + i3, 0);
            }
            padGrid.light(68, 0);
        }
        padGrid.light(69, 0);
        padGrid.light(70, 0);
        padGrid.light(71, 0);
        padGrid.light(85, 0);
        if (host.supports(Capability.NOTE_REPEAT_MODE)) {
            padGrid.light(86, DAWColor.getColorID(ColorEx.WHITE));
            padGrid.light(87, DAWColor.getColorID(ColorEx.WHITE));
        } else {
            padGrid.light(86, DAWColor.getColorID(ColorEx.BLACK));
            padGrid.light(87, DAWColor.getColorID(ColorEx.BLACK));
        }
        int periodIndex = Resolution.getMatch(noteRepeat.getPeriod());
        padGrid.light(88, DAWColor.getColorID((periodIndex == 0 ? DAWColor.DAW_COLOR_GREEN : DAWColor.DAW_COLOR_BLUE).getColor()));
        padGrid.light(72, DAWColor.getColorID((periodIndex == 2 ? DAWColor.DAW_COLOR_GREEN : DAWColor.DAW_COLOR_BLUE).getColor()));
        padGrid.light(56, DAWColor.getColorID((periodIndex == 4 ? DAWColor.DAW_COLOR_GREEN : DAWColor.DAW_COLOR_BLUE).getColor()));
        padGrid.light(40, DAWColor.getColorID((periodIndex == 6 ? DAWColor.DAW_COLOR_GREEN : DAWColor.DAW_COLOR_BLUE).getColor()));
        padGrid.light(89, DAWColor.getColorID((periodIndex == 1 ? DAWColor.DAW_COLOR_GREEN : DAWColor.DAW_COLOR_PINK).getColor()));
        padGrid.light(73, DAWColor.getColorID((periodIndex == 3 ? DAWColor.DAW_COLOR_GREEN : DAWColor.DAW_COLOR_PINK).getColor()));
        padGrid.light(57, DAWColor.getColorID((periodIndex == 5 ? DAWColor.DAW_COLOR_GREEN : DAWColor.DAW_COLOR_PINK).getColor()));
        padGrid.light(41, DAWColor.getColorID((periodIndex == 7 ? DAWColor.DAW_COLOR_GREEN : DAWColor.DAW_COLOR_PINK).getColor()));
        if (this.model.getHost().supports(Capability.NOTE_REPEAT_LENGTH)) {
            int lengthIndex = Resolution.getMatch(noteRepeat.getNoteLength());
            padGrid.light(90, DAWColor.getColorID((lengthIndex == 0 ? DAWColor.DAW_COLOR_GREEN : DAWColor.DAW_COLOR_BLUE).getColor()));
            padGrid.light(74, DAWColor.getColorID((lengthIndex == 2 ? DAWColor.DAW_COLOR_GREEN : DAWColor.DAW_COLOR_BLUE).getColor()));
            padGrid.light(58, DAWColor.getColorID((lengthIndex == 4 ? DAWColor.DAW_COLOR_GREEN : DAWColor.DAW_COLOR_BLUE).getColor()));
            padGrid.light(42, DAWColor.getColorID((lengthIndex == 6 ? DAWColor.DAW_COLOR_GREEN : DAWColor.DAW_COLOR_BLUE).getColor()));
            padGrid.light(91, DAWColor.getColorID((lengthIndex == 1 ? DAWColor.DAW_COLOR_GREEN : DAWColor.DAW_COLOR_PINK).getColor()));
            padGrid.light(75, DAWColor.getColorID((lengthIndex == 3 ? DAWColor.DAW_COLOR_GREEN : DAWColor.DAW_COLOR_PINK).getColor()));
            padGrid.light(59, DAWColor.getColorID((lengthIndex == 5 ? DAWColor.DAW_COLOR_GREEN : DAWColor.DAW_COLOR_PINK).getColor()));
            padGrid.light(43, DAWColor.getColorID((lengthIndex == 7 ? DAWColor.DAW_COLOR_GREEN : DAWColor.DAW_COLOR_PINK).getColor()));
        } else {
            padGrid.light(90, 0);
            padGrid.light(74, 0);
            padGrid.light(58, 0);
            padGrid.light(42, 0);
            padGrid.light(91, 0);
            padGrid.light(75, 0);
            padGrid.light(59, 0);
            padGrid.light(43, 0);
        }
        FireConfiguration configuration = (FireConfiguration)((FireControlSurface)this.surface).getConfiguration();
        int clipLengthIndex = configuration.getNewClipLength();
        for (int i4 = 0; i4 < 8; ++i4) {
            padGrid.light(44 + i4, DAWColor.getColorID((i4 == clipLengthIndex ? DAWColor.DAW_COLOR_RED : DAWColor.DAW_COLOR_LIGHT_ORANGE).getColor()));
        }
        ITransport transport = this.model.getTransport();
        AutomationMode[] automationWriteModes = transport.getAutomationWriteModes();
        AutomationMode writeMode = transport.getAutomationWriteMode();
        for (i = 0; i < automationWriteModes.length; ++i) {
            padGrid.light(60 + i, DAWColor.getColorID((automationWriteModes[i] == writeMode ? DAWColor.DAW_COLOR_RED : DAWColor.DAW_COLOR_GRAY).getColor()));
        }
        for (i = automationWriteModes.length; i < 8; ++i) {
            padGrid.light(60 + i, 0);
        }
        for (i = 0; i < 5; ++i) {
            padGrid.light(76 + i, 0);
        }
        padGrid.light(81, DAWColor.getColorID((this.model.getCursorTrack().isPinned() ? DAWColor.DAW_COLOR_RED : DAWColor.DAW_COLOR_GREEN).getColor()));
        padGrid.light(82, DAWColor.getColorID((this.model.getCursorDevice().isPinned() ? DAWColor.DAW_COLOR_RED : DAWColor.DAW_COLOR_GREEN).getColor()));
        padGrid.light(83, DAWColor.getColorID((this.model.getCursorClip().isPinned() ? DAWColor.DAW_COLOR_RED : DAWColor.DAW_COLOR_GREEN).getColor()));
        padGrid.light(92, 0);
        padGrid.light(96, 0);
        if (configuration.isDuplicateModeActive()) {
            padGrid.light(93, 67, 65, true);
        } else {
            padGrid.light(93, 67);
        }
        padGrid.light(94, 60);
        if (configuration.isDeleteModeActive()) {
            padGrid.light(95, 63, 62, true);
        } else {
            padGrid.light(95, 63);
        }
        padGrid.light(97, DAWColor.getColorID(ColorEx.ORANGE));
        padGrid.light(98, DAWColor.getColorID(ColorEx.BLUE));
        padGrid.light(99, DAWColor.getColorID(ColorEx.PINK));
    }

    @Override
    public void onGridNote(int note, int velocity) {
        if (velocity == 0) {
            return;
        }
        this.setWasUsed();
        FireConfiguration configuration = (FireConfiguration)((FireControlSurface)this.surface).getConfiguration();
        IHost host = this.model.getHost();
        switch (note) {
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                this.setNoteRepeatOctave(note - 36);
                break;
            }
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                this.setNoteRepeatOctave(note - 48);
                break;
            }
            case 68: {
                this.setNoteRepeatOctave(note - 60);
                break;
            }
            case 86: {
                if (!host.supports(Capability.NOTE_REPEAT_MODE)) break;
                ArpeggiatorMode prevArpeggiatorMode = configuration.prevArpeggiatorMode();
                configuration.setNoteRepeatMode(prevArpeggiatorMode);
                this.mvHelper.delayDisplay(() -> "Arp: " + prevArpeggiatorMode.getName());
                break;
            }
            case 87: {
                if (!host.supports(Capability.NOTE_REPEAT_MODE)) break;
                ArpeggiatorMode nextArpeggiatorMode = configuration.nextArpeggiatorMode();
                configuration.setNoteRepeatMode(nextArpeggiatorMode);
                this.mvHelper.delayDisplay(() -> "Arp: " + nextArpeggiatorMode.getName());
                break;
            }
            case 84: {
                configuration.toggleNoteRepeatActive();
                this.mvHelper.delayDisplay(() -> "Note Repeat: " + (configuration.isNoteRepeatActive() ? "On" : "Off"));
                break;
            }
            case 88: {
                this.setPeriod(0);
                break;
            }
            case 89: {
                this.setPeriod(1);
                break;
            }
            case 72: {
                this.setPeriod(2);
                break;
            }
            case 73: {
                this.setPeriod(3);
                break;
            }
            case 56: {
                this.setPeriod(4);
                break;
            }
            case 57: {
                this.setPeriod(5);
                break;
            }
            case 40: {
                this.setPeriod(6);
                break;
            }
            case 41: {
                this.setPeriod(7);
                break;
            }
            case 90: {
                this.setNoteLength(0);
                break;
            }
            case 91: {
                this.setNoteLength(1);
                break;
            }
            case 74: {
                this.setNoteLength(2);
                break;
            }
            case 75: {
                this.setNoteLength(3);
                break;
            }
            case 58: {
                this.setNoteLength(4);
                break;
            }
            case 59: {
                this.setNoteLength(5);
                break;
            }
            case 42: {
                this.setNoteLength(6);
                break;
            }
            case 43: {
                this.setNoteLength(7);
                break;
            }
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                int newClipLength = note - 44;
                configuration.setNewClipLength(newClipLength);
                ((FireControlSurface)this.surface).getDisplay().notify("Clip len: " + AbstractConfiguration.getNewClipLengthValue(newClipLength));
                break;
            }
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: {
                ITransport transport = this.model.getTransport();
                AutomationMode[] automationWriteModes = transport.getAutomationWriteModes();
                int autoIndex = note - 60;
                if (autoIndex >= automationWriteModes.length) break;
                transport.setAutomationWriteMode(automationWriteModes[note - 60]);
                this.mvHelper.notifyAutomationWriteMode();
                break;
            }
            case 81: {
                this.model.getCursorTrack().togglePinned();
                break;
            }
            case 82: {
                this.model.getCursorDevice().togglePinned();
                break;
            }
            case 83: {
                this.model.getCursorClip().togglePinned();
                break;
            }
            case 93: {
                configuration.toggleDuplicateModeActive();
                ((FireControlSurface)this.surface).getDisplay().notify("Duplicate " + (configuration.isDuplicateModeActive() ? "Active" : "Off"));
                break;
            }
            case 94: {
                INoteClip clip = this.model.getCursorClip();
                if (clip.doesExist()) {
                    clip.duplicateContent();
                    ((FireControlSurface)this.surface).getDisplay().notify("Double clip");
                    break;
                }
                ((FireControlSurface)this.surface).getDisplay().notify("No clip.");
                break;
            }
            case 95: {
                configuration.toggleDeleteModeActive();
                ((FireControlSurface)this.surface).getDisplay().notify("Delete " + (configuration.isDeleteModeActive() ? "Active" : "Off"));
                break;
            }
            case 97: {
                this.model.getTrackBank().addChannel(ChannelType.INSTRUMENT);
                return;
            }
            case 98: {
                this.model.getTrackBank().addChannel(ChannelType.AUDIO);
                return;
            }
            case 99: {
                this.model.getApplication().addEffectTrack();
                return;
            }
        }
    }

    private void setPeriod(int index) {
        ((FireConfiguration)((FireControlSurface)this.surface).getConfiguration()).setNoteRepeatPeriod(Resolution.values()[index]);
        ((FireControlSurface)this.surface).scheduleTask(() -> ((FireControlSurface)this.surface).getDisplay().notify("Period: " + Resolution.getNameAt(index)), 100L);
    }

    private void setNoteLength(int index) {
        if (this.model.getHost().supports(Capability.NOTE_REPEAT_LENGTH)) {
            ((FireConfiguration)((FireControlSurface)this.surface).getConfiguration()).setNoteRepeatLength(Resolution.values()[index]);
            ((FireControlSurface)this.surface).scheduleTask(() -> ((FireControlSurface)this.surface).getDisplay().notify("Note Len: " + Resolution.getNameAt(index)), 100L);
        }
    }

    private void setNoteRepeatOctave(int octave) {
        if (this.model.getHost().supports(Capability.NOTE_REPEAT_OCTAVES)) {
            FireConfiguration configuration = (FireConfiguration)((FireControlSurface)this.surface).getConfiguration();
            configuration.setNoteRepeatOctave(octave);
            this.mvHelper.delayDisplay(() -> "Octave: " + configuration.getNoteRepeatOctave());
        }
    }

    @Override
    public int getButtonColor(ButtonID buttonID) {
        ViewManager viewManager = ((FireControlSurface)this.surface).getViewManager();
        return ((IView)viewManager.get((Views)((Object)viewManager.getActiveIDIgnoreTemporary()))).getButtonColor(buttonID);
    }

    @Override
    public void onButton(ButtonID buttonID, ButtonEvent event, int velocity) {
        ViewManager viewManager = ((FireControlSurface)this.surface).getViewManager();
        ((IView)viewManager.get((Views)((Object)viewManager.getActiveIDIgnoreTemporary()))).onButton(buttonID, event, velocity);
    }

    @Override
    public void onSelectKnobValue(int value) {
        ViewManager viewManager = ((FireControlSurface)this.surface).getViewManager();
        IView previousView = (IView)viewManager.get((Views)((Object)viewManager.getActiveIDIgnoreTemporary()));
        if (previousView instanceof IFireView) {
            IFireView fireView = (IFireView)((Object)previousView);
            fireView.onSelectKnobValue(value);
        }
    }

    @Override
    public int getSoloButtonColor(int index) {
        int n;
        ViewManager viewManager = ((FireControlSurface)this.surface).getViewManager();
        IView previousView = (IView)viewManager.get((Views)((Object)viewManager.getActiveIDIgnoreTemporary()));
        if (previousView instanceof IFireView) {
            IFireView fireView = (IFireView)((Object)previousView);
            n = fireView.getSoloButtonColor(index);
        } else {
            n = 0;
        }
        return n;
    }
}

