/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.akai.apc;

import de.mossgrabers.framework.configuration.AbstractConfiguration;
import de.mossgrabers.framework.configuration.ISettingsUI;
import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.constants.Capability;
import de.mossgrabers.framework.daw.midi.ArpeggiatorMode;
import de.mossgrabers.framework.view.Views;
import java.util.List;

public class APCConfiguration
extends AbstractConfiguration {
    private static final Views[] PREFERRED_NOTE_VIEWS = new Views[]{Views.PLAY, Views.DRUM, Views.SEQUENCER, Views.RAINDROPS};
    private final boolean isMkII;

    public APCConfiguration(IHost host, IValueChanger valueChanger, List<ArpeggiatorMode> arpeggiatorModes, boolean isMkII) {
        super(host, valueChanger, arpeggiatorModes);
        this.isMkII = isMkII;
    }

    @Override
    public void init(ISettingsUI globalSettings, ISettingsUI documentSettings) {
        this.activateScaleSetting(documentSettings);
        this.activateScaleBaseSetting(documentSettings);
        this.activateScaleInScaleSetting(documentSettings);
        this.activateScaleLayoutSetting(documentSettings);
        this.activateNoteRepeatSetting(documentSettings);
        this.activateSelectClipOnLaunchSetting(globalSettings);
        this.activateDrawRecordStripeSetting(globalSettings);
        this.activateActionForRecArmedPad(globalSettings);
        this.activateQuantizeAmountSetting(globalSettings);
        this.activateStartupViewSetting(globalSettings, PREFERRED_NOTE_VIEWS);
        this.activateStartWithSessionViewSetting(globalSettings);
        if (this.isMkII) {
            this.activateTurnOffScalePadsSetting(globalSettings);
            this.activateShowPlayedChordsSetting(globalSettings);
        }
        this.activateBehaviourOnPauseSetting(globalSettings);
        if (this.host.supports(Capability.HAS_DRUM_DEVICE)) {
            this.activateTurnOffEmptyDrumPadsSetting(globalSettings);
        }
        this.activateExcludeDeactivatedItemsSetting(globalSettings);
        this.activateNewClipLengthSetting(globalSettings);
        this.activateFootswitchSetting(globalSettings, 0, "Footswitch 1");
        if (!this.isMkII) {
            this.activateFootswitchSetting(globalSettings, 1, "Footswitch 2");
        }
    }
}

