/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ableton.push.mode.configuration;

import de.mossgrabers.controller.ableton.push.PushConfiguration;
import de.mossgrabers.controller.ableton.push.controller.PushControlSurface;
import de.mossgrabers.controller.ableton.push.mode.BaseMode;
import de.mossgrabers.framework.controller.display.IGraphicDisplay;
import de.mossgrabers.framework.controller.display.ITextDisplay;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IItem;
import de.mossgrabers.framework.utils.StringUtils;

public class ConfigurationMode
extends BaseMode<IItem> {
    public ConfigurationMode(PushControlSurface surface, IModel model) {
        super("Configuration", surface, model);
    }

    @Override
    public void onKnobValue(int index, int value) {
        if (index == 0 || index == 1) {
            ((PushConfiguration)((PushControlSurface)this.surface).getConfiguration()).changePadThreshold(value);
        } else if (index == 2 || index == 3) {
            ((PushConfiguration)((PushControlSurface)this.surface).getConfiguration()).changeVelocityCurve(value);
        }
    }

    @Override
    public void onKnobTouch(int index, boolean isTouched) {
        this.setTouchedKnob(index, isTouched);
    }

    @Override
    public void updateDisplay1(ITextDisplay display) {
        display.setBlock(0, 0, "Pad Threshold").setBlock(1, 0, ((PushControlSurface)this.surface).getSelectedPadThreshold());
        display.setBlock(0, 1, "Velocity Curve").setBlock(1, 1, ((PushControlSurface)this.surface).getSelectedVelocityCurve());
        display.setBlock(0, 3, "Firmware: " + ((PushControlSurface)this.surface).getMajorVersion() + "." + ((PushControlSurface)this.surface).getMinorVersion());
        if (((PushConfiguration)((PushControlSurface)this.surface).getConfiguration()).getPadThresholdPush1() < 20) {
            display.setRow(3, StringUtils.pad("Low threshold maycause stuck pads!", 68));
        }
    }

    @Override
    public void updateDisplay2(IGraphicDisplay display) {
    }
}

