/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ableton.push.mode;

import de.mossgrabers.controller.ableton.push.controller.PushControlSurface;
import de.mossgrabers.controller.ableton.push.mode.BaseMode;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.display.IGraphicDisplay;
import de.mossgrabers.framework.controller.display.ITextDisplay;
import de.mossgrabers.framework.daw.IApplication;
import de.mossgrabers.framework.daw.IArranger;
import de.mossgrabers.framework.daw.IMixer;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IItem;
import de.mossgrabers.framework.utils.ButtonEvent;

public class FrameMode
extends BaseMode<IItem> {
    private static final String ROW0 = "Layouts:                  Panels:                                   ";
    private static final String ROW1 = "Arrange  Mix     Edit     Notes   Automate Device  Mixer    Inspectr";
    private static final String[] ARRANGER_ROWS = new String[]{"Arranger:                                                           ", "ClpLnchr I/O     Markers  TimelineFXTracks Follow  TrckHght Full    "};
    private static final String[] MIXER_ROWS = new String[]{"Mixer:                                                              ", "ClpLnchr I/O     CrossFde Device  Meters   Sends            Full    "};
    private static final String[] EMPTY_ROWS = new String[]{"                                                                    ", "                                                                    "};
    private static final String[] LAYOUTS1 = new String[]{"Layouts", "", "", "Panels", "", "", "", ""};
    private static final String[] LAYOUTS2 = new String[]{"Arrange", "Mix", "Edit", "Notes", "Automate", "Device", "Mixer", "Inspector"};
    private static final String[][] ARRANGER_OPTIONS = new String[][]{{"Arranger", "", "", "", "", "", "", ""}, {"Clip Launcher", "I/O", "Markers", "Timeline", "FX Tracks", "Follow", "Track Height", "Fullscreen"}};
    private static final String[][] MIXER_OPTIONS = new String[][]{{"Mixer", "", "", "", "", "", "", ""}, {"Clip Launcher", "I/O", "Crossfader", "Device", "Meters", "Sends", "", "Fullscreen"}};
    private static final String[][] EMPTY_OPTIONS = new String[][]{{"", "", "", "", "", "", "", ""}, {"", "", "", "", "", "", "", ""}};

    public FrameMode(PushControlSurface surface, IModel model) {
        super("Frame", surface, model);
    }

    @Override
    public void onActivate() {
        super.onActivate();
        this.setActive(true);
    }

    @Override
    public void onDeactivate() {
        super.onDeactivate();
        this.setActive(false);
    }

    @Override
    public void onFirstRow(int index, ButtonEvent event) {
        if (event != ButtonEvent.UP) {
            return;
        }
        IApplication app = this.model.getApplication();
        switch (index) {
            case 0: {
                app.setPanelLayout("ARRANGE");
                break;
            }
            case 1: {
                app.setPanelLayout("MIX");
                break;
            }
            case 2: {
                app.setPanelLayout("EDIT");
                break;
            }
            case 3: {
                app.toggleNoteEditor();
                break;
            }
            case 4: {
                app.toggleAutomationEditor();
                break;
            }
            case 5: {
                app.toggleDevices();
                break;
            }
            case 6: {
                app.toggleMixer();
                break;
            }
            case 7: {
                app.toggleInspector();
                break;
            }
        }
    }

    @Override
    public void onSecondRow(int index, ButtonEvent event) {
        if (event != ButtonEvent.UP) {
            return;
        }
        IApplication app = this.model.getApplication();
        if (app.isArrangeLayout()) {
            IArranger arrange = this.model.getArranger();
            switch (index) {
                case 0: {
                    arrange.toggleClipLauncher();
                    break;
                }
                case 1: {
                    arrange.toggleIoSection();
                    break;
                }
                case 2: {
                    arrange.toggleCueMarkerVisibility();
                    break;
                }
                case 3: {
                    arrange.toggleTimeLine();
                    break;
                }
                case 4: {
                    arrange.toggleEffectTracks();
                    break;
                }
                case 5: {
                    arrange.togglePlaybackFollow();
                    break;
                }
                case 6: {
                    arrange.toggleTrackRowHeight();
                    break;
                }
                case 7: {
                    app.toggleFullScreen();
                    break;
                }
            }
        } else if (app.isMixerLayout()) {
            IMixer mix = this.model.getMixer();
            switch (index) {
                case 0: {
                    mix.toggleClipLauncherSectionVisibility();
                    break;
                }
                case 1: {
                    mix.toggleIoSectionVisibility();
                    break;
                }
                case 2: {
                    mix.toggleCrossFadeSectionVisibility();
                    break;
                }
                case 3: {
                    mix.toggleDeviceSectionVisibility();
                    break;
                }
                case 4: {
                    mix.toggleMeterSectionVisibility();
                    break;
                }
                case 5: {
                    mix.toggleSendsSectionVisibility();
                    break;
                }
                case 7: {
                    app.toggleFullScreen();
                    break;
                }
            }
        }
    }

    @Override
    public void updateDisplay1(ITextDisplay display) {
        IApplication app = this.model.getApplication();
        String[] rows34 = app.isArrangeLayout() ? ARRANGER_ROWS : (app.isMixerLayout() ? MIXER_ROWS : EMPTY_ROWS);
        display.setRow(0, ROW0).setRow(1, ROW1).setRow(2, rows34[0]).setRow(3, rows34[1]);
    }

    @Override
    public void updateDisplay2(IGraphicDisplay display) {
        IApplication app = this.model.getApplication();
        String[][] options = app.isArrangeLayout() ? ARRANGER_OPTIONS : (app.isMixerLayout() ? MIXER_OPTIONS : EMPTY_OPTIONS);
        for (int i = 0; i < 8; ++i) {
            display.addOptionElement(options[0][i], options[1][i], this.getSecondRowButtonState(i) > 0, LAYOUTS1[i], LAYOUTS2[i], this.getFirstRowButtonState(i), false);
        }
    }

    @Override
    public int getButtonColor(ButtonID buttonID) {
        int index = this.isButtonRow(0, buttonID);
        if (index >= 0) {
            return this.colorManager.getColorIndex(this.getFirstRowButtonState(index) ? "BUTTON_COLOR_HI" : "BUTTON_COLOR_ON");
        }
        index = this.isButtonRow(1, buttonID);
        if (index >= 0) {
            return this.colorManager.getColorIndex(switch (this.getSecondRowButtonState(index)) {
                case 0 -> "BUTTON_COLOR2_ON";
                case 1 -> "BUTTON_COLOR2_HI";
                default -> "BUTTON_COLOR_OFF";
            });
        }
        return super.getButtonColor(buttonID);
    }

    private boolean getFirstRowButtonState(int index) {
        switch (index) {
            case 0: {
                return this.model.getApplication().isArrangeLayout();
            }
            case 1: {
                return this.model.getApplication().isMixerLayout();
            }
            case 2: {
                return this.model.getApplication().isEditLayout();
            }
        }
        return false;
    }

    private int getSecondRowButtonState(int index) {
        IApplication app = this.model.getApplication();
        if (app.isArrangeLayout()) {
            IArranger arrange = this.model.getArranger();
            switch (index) {
                case 0: {
                    return arrange.isClipLauncherVisible() ? 1 : 0;
                }
                case 1: {
                    return arrange.isIoSectionVisible() ? 1 : 0;
                }
                case 2: {
                    return arrange.areCueMarkersVisible() ? 1 : 0;
                }
                case 3: {
                    return arrange.isTimelineVisible() ? 1 : 0;
                }
                case 4: {
                    return arrange.areEffectTracksVisible() ? 1 : 0;
                }
                case 5: {
                    return arrange.isPlaybackFollowEnabled() ? 1 : 0;
                }
                case 6: {
                    return arrange.hasDoubleRowTrackHeight() ? 1 : 0;
                }
            }
            return 0;
        }
        if (app.isMixerLayout()) {
            IMixer mix = this.model.getMixer();
            switch (index) {
                case 0: {
                    return mix.isClipLauncherSectionVisible() ? 1 : 0;
                }
                case 1: {
                    return mix.isIoSectionVisible() ? 1 : 0;
                }
                case 2: {
                    return mix.isCrossFadeSectionVisible() ? 1 : 0;
                }
                case 3: {
                    return mix.isDeviceSectionVisible() ? 1 : 0;
                }
                case 4: {
                    return mix.isMeterSectionVisible() ? 1 : 0;
                }
                case 5: {
                    return mix.isSendSectionVisible() ? 1 : 0;
                }
                case 6: {
                    return -1;
                }
            }
            return 0;
        }
        return -1;
    }

    private void setActive(boolean enable) {
        this.model.getArranger().enableObservers(enable);
        this.model.getMixer().enableObservers(enable);
    }
}

