/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ableton.push.command.trigger;

import de.mossgrabers.controller.ableton.push.PushConfiguration;
import de.mossgrabers.controller.ableton.push.controller.PushControlSurface;
import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import de.mossgrabers.framework.featuregroup.ModeManager;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.utils.ButtonEvent;
import java.util.Optional;

public class TrackCommand
extends AbstractTriggerCommand<PushControlSurface, PushConfiguration> {
    public TrackCommand(IModel model, PushControlSurface surface) {
        super(model, surface);
    }

    @Override
    public void execute(ButtonEvent event, int velocity) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        PushConfiguration config = (PushConfiguration)((PushControlSurface)this.surface).getConfiguration();
        if (((PushControlSurface)this.surface).isShiftPressed()) {
            config.setVUMetersEnabled(!config.isEnableVUMeters());
            return;
        }
        ModeManager modeManager = ((PushControlSurface)this.surface).getModeManager();
        Modes currentMode = (Modes)((Object)modeManager.getActiveID());
        if (currentMode != null) {
            if (config.isPushModern()) {
                if (Modes.TRACK.equals((Object)currentMode) || Modes.VOLUME.equals((Object)currentMode) || Modes.CROSSFADER.equals((Object)currentMode) || Modes.PAN.equals((Object)currentMode)) {
                    this.model.toggleCurrentTrackBank();
                } else if (currentMode.ordinal() >= Modes.SEND1.ordinal() && currentMode.ordinal() <= Modes.SEND8.ordinal()) {
                    modeManager.setActive(Modes.TRACK);
                    this.model.toggleCurrentTrackBank();
                } else {
                    modeManager.setActive(config.getCurrentMixMode());
                }
            } else {
                if (((PushControlSurface)this.surface).isSelectPressed() && Modes.isLayerMode(currentMode)) {
                    ((PushControlSurface)this.surface).setTriggerConsumed(ButtonID.SELECT);
                    modeManager.setActive(Modes.DEVICE_LAYER);
                    return;
                }
                if (Modes.TRACK.equals((Object)currentMode)) {
                    this.model.toggleCurrentTrackBank();
                } else {
                    modeManager.setActive(Modes.TRACK);
                }
            }
        } else {
            modeManager.setActive(Modes.TRACK);
        }
        config.setMixerMode((Modes)((Object)modeManager.getActiveID()));
        ITrackBank tb = this.model.getCurrentTrackBank();
        Optional track = tb.getSelectedItem();
        if (track.isEmpty()) {
            ((ITrack)tb.getItem(0)).select();
        }
    }
}

