/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ableton.push.command.continuous;

import de.mossgrabers.controller.ableton.push.PushConfiguration;
import de.mossgrabers.controller.ableton.push.controller.PushControlSurface;
import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.featuregroup.ModeManager;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.parameter.IFocusedParameter;
import de.mossgrabers.framework.parameter.IParameter;
import de.mossgrabers.framework.utils.ButtonEvent;
import java.util.Optional;

public class ConfigurePitchbendCommand
extends AbstractTriggerCommand<PushControlSurface, PushConfiguration> {
    public ConfigurePitchbendCommand(IModel model, PushControlSurface surface) {
        super(model, surface);
    }

    @Override
    public void executeNormal(ButtonEvent event) {
        if (event != ButtonEvent.DOWN || !((PushControlSurface)this.surface).isDeletePressed()) {
            return;
        }
        ((PushControlSurface)this.surface).setTriggerConsumed(ButtonID.DELETE);
        IParameter parameter = null;
        switch (((PushConfiguration)((PushControlSurface)this.surface).getConfiguration()).getRibbonMode()) {
            case 4: {
                parameter = this.model.getCursorTrack().getVolumeParameter();
                break;
            }
            case 5: {
                Optional<IFocusedParameter> focusedParameter = this.model.getFocusedParameter();
                parameter = focusedParameter.isPresent() ? (IParameter)focusedParameter.get() : null;
                break;
            }
        }
        if (parameter != null) {
            parameter.resetValue();
        }
    }

    @Override
    public void executeShifted(ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        ModeManager modeManager = ((PushControlSurface)this.surface).getModeManager();
        if (!modeManager.isActive(new Modes[]{Modes.RIBBON})) {
            modeManager.setTemporary(Modes.RIBBON);
        }
    }
}

