/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.daw.data.parameter;

import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.parameter.AbstractParameterImpl;
import de.mossgrabers.reaper.communication.BackendExchange;
import de.mossgrabers.reaper.communication.Processor;
import de.mossgrabers.reaper.framework.daw.DataSetupEx;
import de.mossgrabers.reaper.framework.daw.data.parameter.IParameterEx;
import java.text.DecimalFormat;

public class TempoParameterImpl
extends AbstractParameterImpl
implements IParameterEx {
    private static final double DEFAULT_TEMPO = 120.0;
    private final BackendExchange sender;
    private double tempo = 120.0;

    public TempoParameterImpl(DataSetupEx dataSetup) {
        super(dataSetup.getValueChanger(), -1);
        this.sender = dataSetup.getSender();
    }

    @Override
    public void setValue(IValueChanger valueChanger, int value) {
        this.setInternalValue(value);
    }

    @Override
    public void changeValue(IValueChanger valueChanger, int control) {
        boolean slow;
        boolean increase = valueChanger.isIncrease(control);
        boolean bl = slow = Math.abs(valueChanger.calcKnobChange(control)) > 1.0;
        String dir = increase ? (slow ? "+" : "++") : (slow ? "-" : "--");
        this.sender.processNoArg(Processor.TEMPO, dir);
    }

    @Override
    public void resetValue() {
        this.setInternalValue(120.0);
    }

    @Override
    public String getDisplayedValue() {
        return new DecimalFormat("#.00").format(this.tempo);
    }

    @Override
    public void setInternalValue(double value) {
        this.tempo = value;
    }

    @Override
    public double getInternalValue() {
        return this.tempo;
    }

    @Override
    public void setValueStr(String valueStr) {
    }

    @Override
    public void setInternalName(String value) {
    }

    @Override
    public void setPosition(int paramNo) {
    }

    @Override
    public void setExists(boolean exists) {
    }

    @Override
    public void setInternalNumberOfSteps(int numberOfSteps) {
    }
}

